/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i;
        @NotNull String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i = 1; i < 21; ++i) {
            charToString[i] = Character.toString((char)(i + 9351));
        }
        for (i = 32; i < 256; ++i) {
            charToString[i] = Character.toString((char)i);
        }
        for (i = 21; i < 32; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        for (i = 128; i < 160; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        return charToString;
    }

    default public int peekVolatileInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readVolatileInt(this.readPosition());
    }

    default public boolean readBoolean(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesUtil.byteToBoolean(this.readByte(offset));
    }

    public byte readByte(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    default public int readUnsignedByte(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return this.readByte(offset) & 0xFF;
    }

    public int peekUnsignedByte(@NonNegative long var1) throws ClosedIllegalStateException, ThreadingIllegalStateException;

    public short readShort(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    default public int readUnsignedShort(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return this.readShort(offset) & 0xFFFF;
    }

    default public int readUnsignedInt24(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return this.readUnsignedShort(offset) | this.readUnsignedByte(offset) << 16;
    }

    public int readInt(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    default public long readUnsignedInt(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    public float readFloat(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    public double readDouble(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException;

    default public String printable(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return charToString[this.readUnsignedByte(offset)];
    }

    public byte readVolatileByte(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public short readVolatileShort(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public int readVolatileInt(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public float readVolatileFloat(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    public long readVolatileLong(@NonNegative long var1) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public double readVolatileDouble(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    default public long parseLong(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.parseLong(this, offset);
    }

    public void nativeRead(@NonNegative long var1, long var3, @NonNegative long var5) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public int copyTo(byte[] bytes) throws BufferUnderflowException, ClosedIllegalStateException {
        int i;
        ObjectUtils.requireNonNull((Object)bytes);
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        long readPosition = this.readPosition();
        for (i = 0; i < len - 7; i += 8) {
            UnsafeMemory.unsafePutLong((byte[])bytes, (int)i, (long)this.readLong(readPosition + (long)i));
        }
        while (i < len) {
            bytes[i] = this.readByte(readPosition + (long)i);
            ++i;
        }
        return len;
    }

    default public int copyTo(@NotNull ByteBuffer bb) throws BufferUnderflowException, ClosedIllegalStateException {
        int i;
        ObjectUtils.requireNonNull((Object)bb);
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        int pos = bb.position();
        int len = (int)Math.min((long)bb.remaining(), this.readRemaining());
        long readPosition = this.readPosition();
        for (i = 0; i < len - 7; i += 8) {
            bb.putLong(pos + i, this.readLong(readPosition + (long)i));
        }
        while (i < len) {
            bb.put(pos + i, this.readByte(readPosition + (long)i));
            ++i;
        }
        return len;
    }

    default public long readIncompleteLong(@NonNegative long offset) throws ClosedIllegalStateException {
        long left = this.readLimit() - offset;
        if (left >= 8L) {
            return this.readLong(offset);
        }
        if (left == 4L) {
            return this.readInt(offset);
        }
        long l = 0L;
        int remaining = (int)left;
        for (int i = 0; i < remaining; ++i) {
            l |= (long)this.readUnsignedByte(offset + (long)i) << i * 8;
        }
        return l;
    }

    @Override
    @NonNegative
    public long realCapacity();

    @Deprecated
    default public int addAndGetInt(@NonNegative long offset, int adding) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.addAndGetInt((BytesStore)this, offset, adding);
    }

    @Deprecated
    default public long addAndGetLong(@NonNegative long offset, long adding) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.addAndGetLong((BytesStore)this, offset, adding);
    }

    @Deprecated
    default public float addAndGetFloat(@NonNegative long offset, float adding) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.addAndGetFloat((BytesStore)this, offset, adding);
    }

    @Deprecated
    default public double addAndGetDouble(@NonNegative long offset, double adding) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.addAndGetDouble((BytesStore)this, offset, adding);
    }

    @Deprecated
    public boolean compareAndSwapInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, ClosedIllegalStateException;

    @Deprecated
    public void testAndSetInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, ClosedIllegalStateException;

    @Deprecated
    public boolean compareAndSwapLong(@NonNegative long var1, long var3, long var5) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @Deprecated
    default public boolean compareAndSwapFloat(@NonNegative long offset, float expected, float value) throws BufferOverflowException, ClosedIllegalStateException {
        return this.compareAndSwapInt(offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(value));
    }

    @Deprecated
    default public boolean compareAndSwapDouble(@NonNegative long offset, double expected, double value) throws BufferOverflowException, ClosedIllegalStateException {
        return this.compareAndSwapLong(offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(value));
    }

    @NotNull
    default public BytesStore subBytes(@NonNegative long start, @NonNegative long length) throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.subBytes(this, start, length);
    }

    default public long findByte(byte stopByte) throws ClosedIllegalStateException {
        return BytesInternal.findByte(this, stopByte);
    }

    default public <T extends Appendable & CharSequence> long readUtf8(@NonNegative long offset, @NotNull T sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int len = Maths.toUInt31((long)utfLen);
        BytesInternal.parseUtf8(this, offset, sb, true, len);
        return offset + utfLen;
    }

    default public <T extends Appendable & CharSequence> long readUtf8Limited(@NonNegative long offset, @NotNull T sb, @NonNegative int maxUtf8Len) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, ClosedIllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (utfLen > (long)maxUtf8Len) {
            throw new ClosedIllegalStateException("Attempted to read a char sequence of utf8 size " + utfLen + ", when only " + maxUtf8Len + " allowed");
        }
        BytesInternal.parseUtf8(this, offset, sb, true, (int)utfLen);
        return offset + utfLen;
    }

    @Nullable
    default public String readUtf8Limited(@NonNegative long offset, @NonNegative int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, ClosedIllegalStateException {
        return BytesInternal.readUtf8(this, offset, maxUtf8Len);
    }

    default public boolean compareUtf8(@NonNegative long offset, @Nullable CharSequence other) throws IORuntimeException, BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.compareUtf8(this, offset, other);
    }

    default public byte[] toByteArray() throws ClosedIllegalStateException {
        return BytesInternal.toByteArray(this);
    }

    default public long read(@NonNegative long offsetInRDI, byte[] bytes, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        int len = Maths.toUInt31((long)Math.min((long)length, Longs.requireNonNegative((long)(this.readLimit() - offsetInRDI))));
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = this.readByte(offsetInRDI + (long)i);
        }
        return len;
    }

    default public ByteBuffer toTemporaryDirectByteBuffer() throws IllegalArgumentException, ArithmeticException, ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        int len = Maths.toUInt31((long)this.readRemaining());
        ByteBuffer bb = ByteBuffer.allocateDirect(len);
        this.copyTo(bb);
        bb.clear();
        return bb;
    }

    default public int fastHash(@NonNegative long offset, @NonNegative int length) throws BufferUnderflowException, ClosedIllegalStateException {
        long hash = 0L;
        int i = 0;
        if (length >= 4) {
            hash = this.readInt(offset + (long)i);
            i += 4;
        }
        while (i < length - 3) {
            hash *= 1829709757L;
            hash += (long)this.readInt(offset + (long)i);
            i += 4;
        }
        if (i < length - 1) {
            hash *= 1829709757L;
            hash += (long)this.readShort(offset + (long)i);
            i += 2;
        }
        if (i < length) {
            hash += (long)this.readByte(offset + (long)i);
        }
        return (int)((hash *= -2057448229L) ^ hash >> 32);
    }

    default public boolean canReadDirect() {
        return this.canReadDirect();
    }

    default public boolean canReadDirect(@NonNegative long length) {
        return this.isDirectMemory() && this.readRemaining() >= length;
    }
}

