/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataOutput<R extends RandomDataOutput<R>>
extends RandomCommon {
    @NotNull
    default public R writeByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException, ArithmeticException, IllegalStateException {
        return this.writeByte(offset, Maths.toInt8((long)i));
    }

    @NotNull
    default public R writeUnsignedByte(long offset, int i) throws BufferOverflowException, IllegalArgumentException, ArithmeticException, IllegalStateException {
        return this.writeByte(offset, (byte)Maths.toUInt8((long)i));
    }

    @NotNull
    default public R writeBoolean(long offset, boolean flag) throws BufferOverflowException, IllegalStateException {
        try {
            return this.writeByte(offset, flag ? 89 : 78);
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public R writeUnsignedShort(long offset, int i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.writeShort(offset, (short)Maths.toUInt16((long)i));
    }

    @NotNull
    default public R writeUnsignedInt(long offset, long i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        return this.writeInt(offset, (int)Maths.toUInt32((long)i));
    }

    @NotNull
    public R writeByte(@NonNegative long var1, byte var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeShort(@NonNegative long var1, short var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public R writeInt24(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.writeShort(offset, (short)i);
        return this.writeByte(offset + 2L, (byte)(i >> 16));
    }

    @NotNull
    public R writeInt(@NonNegative long var1, int var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeOrderedInt(@NonNegative long var1, int var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public R writeOrderedFloat(long offset, float f) throws BufferOverflowException, IllegalStateException {
        return this.writeOrderedInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    public R writeLong(@NonNegative long var1, long var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeOrderedLong(@NonNegative long var1, long var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public R writeOrderedDouble(long offset, double d) throws BufferOverflowException, IllegalStateException {
        return this.writeOrderedLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    public R writeFloat(@NonNegative long var1, float var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeDouble(@NonNegative long var1, double var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeVolatileByte(@NonNegative long var1, byte var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeVolatileShort(@NonNegative long var1, short var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeVolatileInt(@NonNegative long var1, int var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    public R writeVolatileLong(@NonNegative long var1, long var3) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public R writeVolatileFloat(@NonNegative long offset, float f) throws BufferOverflowException, IllegalStateException {
        return this.writeVolatileInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    default public R writeVolatileDouble(@NonNegative long offset, double d) throws BufferOverflowException, IllegalStateException {
        return this.writeVolatileLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    default public R write(@NonNegative long offsetInRDO, byte[] bytes) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        return this.write(offsetInRDO, bytes, 0, bytes.length);
    }

    @NotNull
    public R write(@NonNegative long var1, byte[] var3, @NonNegative int var4, @NonNegative int var5) throws BufferOverflowException, IllegalStateException;

    public void write(@NonNegative long var1, @NotNull ByteBuffer var3, @NonNegative int var4, @NonNegative int var5) throws BufferOverflowException, IllegalStateException;

    @NotNull
    default public R write(@NonNegative long offsetInRDO, @NotNull BytesStore bytes) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        try {
            return this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public R write(@NonNegative long var1, @NotNull RandomDataInput var3, @NonNegative long var4, @NonNegative long var6) throws BufferOverflowException, BufferUnderflowException, IllegalStateException;

    @NotNull
    public R zeroOut(@NonNegative long var1, @NonNegative long var3) throws IllegalStateException;

    @NotNull
    default public R append(@NonNegative long offset, long value, int digits) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        BytesInternal.append(this, offset, value, digits);
        return (R)this;
    }

    @NotNull
    default public R append(@NonNegative long offset, double value, int decimalPlaces, int digits) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, ArithmeticException {
        double d2;
        if (decimalPlaces < 20 && (d2 = value * (double)Maths.tens((int)decimalPlaces)) <= 9.223372036854776E18 && d2 >= -9.223372036854776E18) {
            BytesInternal.appendDecimal(this, Math.round(d2), offset, decimalPlaces, digits);
            return (R)this;
        }
        BytesInternal.append((StreamingDataOutput)((Object)this), value);
        return (R)this;
    }

    public void nativeWrite(long var1, @NonNegative long var3, @NonNegative long var5) throws BufferOverflowException, IllegalStateException;

    default public long writeUtf8(@NonNegative long writeOffset, @Nullable CharSequence text) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.writeUtf8(this, writeOffset, text);
    }

    default public long writeUtf8Limited(@NonNegative long writeOffset, @Nullable CharSequence text, @NonNegative int maxUtf8Len) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.writeUtf8(this, writeOffset, text, maxUtf8Len);
    }

    public long write8bit(@NonNegative long var1, @NotNull BytesStore var3);

    public long write8bit(@NonNegative long var1, @NotNull String var3, @NonNegative int var4, @NonNegative int var5);

    public boolean compareAndSwapInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, IllegalStateException;

    public void testAndSetInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, IllegalStateException;

    public boolean compareAndSwapLong(@NonNegative long var1, long var3, long var5) throws BufferOverflowException, IllegalStateException;

    public boolean compareAndSwapFloat(@NonNegative long var1, float var3, float var4);

    public boolean compareAndSwapDouble(@NonNegative long var1, double var3, double var5);

    public int addAndGetInt(@NonNegative long var1, int var3);

    public long addAndGetLong(@NonNegative long var1, long var3);

    public float addAndGetFloat(@NonNegative long var1, float var3);

    public double addAndGetDouble(@NonNegative long var1, double var3);

    default public long appendAndReturnLength(long writePosition, boolean negative, long mantissa, int exponent, boolean append0) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] internalNumberBuffer();
}

