/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.posix.PosixAPI;
import org.jetbrains.annotations.NotNull;

public class MappedBytesStore
extends NativeBytesStore<Void> {
    @NotNull
    public static final MappedBytesStoreFactory MAPPED_BYTES_STORE_FACTORY = MappedBytesStore::new;
    protected final Runnable writeCheck;
    private final MappedFile mappedFile;
    private final long start;
    private final long safeLimit;
    private SyncMode syncMode = MappedFile.DEFAULT_SYNC_MODE;
    private long syncLength = 0L;

    protected MappedBytesStore(ReferenceOwner owner, MappedFile mappedFile, @NonNegative long start, long address, @NonNegative long capacity, @NonNegative long safeCapacity) throws IllegalStateException {
        super(address, start + capacity, (Runnable)new OS.Unmapper(address, capacity), false);
        this.mappedFile = mappedFile;
        this.start = start;
        this.safeLimit = start + safeCapacity;
        this.writeCheck = mappedFile.readOnly() ? MappedBytesStore::throwReadOnly : MappedBytesStore::readWriteOk;
        this.reserveTransfer(INIT, owner);
    }

    static void throwReadOnly() {
        throw new IllegalStateException("Read Only");
    }

    static void readWriteOk() {
    }

    public long underlyingCapacity() {
        return this.mappedFile.capacity();
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForRead() throws IllegalStateException {
        try {
            return (Bytes)new NativeBytes(this).readLimit(this.writeLimit()).readPosition(this.start());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws IllegalStateException {
        this.writeCheck.run();
        try {
            return new NativeBytes<Void>(this);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean inside(@NonNegative long offset) {
        return this.start <= offset && offset < this.safeLimit;
    }

    @Override
    public boolean inside(@NonNegative long offset, @NonNegative long buffer) {
        return this.start <= offset && offset + buffer <= this.limit;
    }

    @Override
    public long safeLimit() {
        return this.safeLimit;
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        return this.memory.readByte(this.address - this.start + offset);
    }

    @Override
    @NotNull
    public MappedBytesStore writeOrderedInt(@NonNegative long offset, int i) throws IllegalStateException {
        this.writeCheck.run();
        this.memory.writeOrderedInt(this.address - this.start + offset, i);
        return this;
    }

    @Override
    public long translate(@NonNegative long offset) {
        assert (offset >= this.start);
        assert (offset < this.limit);
        return offset - this.start;
    }

    @Override
    @NonNegative
    public long start() {
        return this.start;
    }

    @Override
    @NonNegative
    public long readPosition() {
        return this.start();
    }

    public FileLock lock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.mappedFile.lock(position, size, shared);
    }

    public FileLock tryLock(@NonNegative long position, @NonNegative long size, boolean shared) throws IOException {
        return this.mappedFile.tryLock(position, size, shared);
    }

    @Override
    @NotNull
    public MappedBytesStore zeroOut(@NonNegative long start, @NonNegative long end) {
        this.writeCheck.run();
        super.zeroOut(start, end);
        return this;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws IllegalStateException {
        this.writeCheck.run();
        return super.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws IllegalStateException {
        this.writeCheck.run();
        return super.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public MappedBytesStore writeByte(@NonNegative long offset, byte i8) throws IllegalStateException {
        this.writeCheck.run();
        super.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeShort(@NonNegative long offset, short i16) throws IllegalStateException {
        this.writeCheck.run();
        super.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeInt(@NonNegative long offset, int i32) throws IllegalStateException {
        this.writeCheck.run();
        super.writeInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeLong(@NonNegative long offset, long i64) throws IllegalStateException {
        this.writeCheck.run();
        super.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeOrderedLong(@NonNegative long offset, long i) throws IllegalStateException {
        this.writeCheck.run();
        super.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeFloat(@NonNegative long offset, float f) throws IllegalStateException {
        this.writeCheck.run();
        super.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeDouble(@NonNegative long offset, double d) throws IllegalStateException {
        this.writeCheck.run();
        super.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileByte(@NonNegative long offset, byte i8) throws IllegalStateException {
        this.writeCheck.run();
        super.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileShort(@NonNegative long offset, short i16) throws IllegalStateException {
        this.writeCheck.run();
        super.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileInt(@NonNegative long offset, int i32) throws IllegalStateException {
        this.writeCheck.run();
        super.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore writeVolatileLong(@NonNegative long offset, long i64) throws IllegalStateException {
        this.writeCheck.run();
        super.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws IllegalStateException {
        this.writeCheck.run();
        super.write(offsetInRDO, byteArray, offset, length);
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws IllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        this.writeCheck.run();
        super.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public MappedBytesStore write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        Longs.requireNonNegative((long)writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)readOffset);
        Longs.requireNonNegative((long)length);
        this.throwExceptionIfReleased();
        this.writeCheck.run();
        super.write(writeOffset, bytes, readOffset, length);
        return this;
    }

    @Override
    public void write0(@NonNegative long offsetInRDO, @NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        this.writeCheck.run();
        super.write0(offsetInRDO, bytes, offset, length);
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) throws IllegalStateException {
        this.writeCheck.run();
        super.nativeWrite(address, position, size);
    }

    @Override
    public long appendUtf8(@NonNegative long pos, char[] chars, @NonNegative int offset, @NonNegative int length) throws IllegalStateException {
        this.writeCheck.run();
        return super.appendUtf8(pos, chars, offset, length);
    }

    @Override
    protected void performRelease() {
        if (this.address != 0L && this.syncMode != SyncMode.NONE && OS.isLinux()) {
            this.performMsync(0L, this.safeLimit - this.start);
        }
        super.performRelease();
    }

    private void performMsync(long offset, long length) {
        long start0 = System.currentTimeMillis();
        PosixAPI.posix().msync(this.address + offset, length, this.syncMode.mSyncFlag());
        long time0 = System.currentTimeMillis() - start0;
        if (time0 >= 10L) {
            Jvm.perf().on(this.getClass(), "Took " + (double)time0 / 1000.0 + " seconds to " + (Object)((Object)this.syncMode) + " " + this.mappedFile.file());
        }
    }

    public SyncMode syncMode() {
        return this.syncMode;
    }

    public void syncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    public void syncUpTo(long position) {
        if (this.syncMode == SyncMode.NONE || this.address == 0L || this.refCount() <= 0) {
            return;
        }
        long length = position - this.start;
        if (length <= this.syncLength) {
            return;
        }
        long maxLength = this.safeLimit - this.start;
        if (length > maxLength) {
            length = maxLength;
        }
        long pageEnd = length + 4095L & 0xFFFFFFFFFFFFF000L;
        long pageStart = length & 0xFFFFFFFFFFFFF000L;
        long length2 = pageEnd - this.syncLength;
        this.performMsync(this.syncLength, length2);
        this.syncLength = pageStart;
    }
}

