/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum MappedUniqueTimeProvider implements TimeProvider,
ReferenceOwner
{
    INSTANCE;

    private static final int LAST_TIME = 128;
    private static final int NANOS_PER_MICRO = 1000;
    private final Bytes bytes;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    private MappedUniqueTimeProvider() {
        try {
            String user = System.getProperty("user.name", "unknown");
            String timeStampDir = System.getProperty("timestamp.dir", OS.TMP);
            File timeStampPath = new File(timeStampDir, ".time-stamp." + user + ".dat");
            MappedFile file = MappedFile.ofSingle(timeStampPath, OS.pageSize(), false);
            this.bytes = file.acquireBytesForWrite(this, 0L);
            this.bytes.append8bit("&TSF\nTime stamp file used for sharing a unique id\n");
            IOTools.unmonitor((Object)((Object)file));
            IOTools.unmonitor((Object)this.bytes);
        }
        catch (Exception ioe) {
            throw new IORuntimeException((Throwable)ioe);
        }
    }

    public MappedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    public long currentTimeMicros() throws IllegalStateException {
        long timeus = this.provider.currentTimeMicros();
        long time0us;
        long time;
        long time0;
        while (!this.bytes.compareAndSwapLong(128L, time0, time = (time0us = (time0 = this.bytes.readVolatileLong(128L)) / 1000L) >= timeus ? (time0us + 1L) * 1000L : timeus * 1000L)) {
            Jvm.nanoPause();
        }
        return time / 1000L;
    }

    public long currentTimeNanos() throws IllegalStateException {
        long time0;
        long timeNanos5;
        long time = this.provider.currentTimeNanos();
        long time5 = time >>> 5;
        if (time5 > (timeNanos5 = (time0 = this.bytes.readVolatileLong(128L)) >>> 5) && this.bytes.compareAndSwapLong(128L, time0, time)) {
            return time;
        }
        long next;
        while (!this.bytes.compareAndSwapLong(128L, time0 = this.bytes.readVolatileLong(128L), next = time0 + 32L & 0xFFFFFFFFFFFFFFE0L)) {
            Jvm.nanoPause();
        }
        return next;
    }
}

