/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.pool;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IOTools;
import org.jetbrains.annotations.NotNull;

public class BytesPool {
    final ThreadLocal<Bytes> bytesTL = new ThreadLocal();

    public Bytes acquireBytes() {
        Bytes bytes = this.bytesTL.get();
        if (bytes != null) {
            try {
                return bytes.clear();
            }
            catch (IllegalStateException illegalStateException) {
            }
        } else {
            bytes = this.createBytes();
            this.bytesTL.set(bytes);
        }
        return bytes;
    }

    @NotNull
    protected Bytes createBytes() {
        Bytes<ByteBuffer> bbb = Bytes.elasticHeapByteBuffer(256);
        IOTools.unmonitor(bbb);
        return bbb;
    }
}

