/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.TwoLongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryTwoLongReference
extends BinaryLongReference
implements TwoLongReference {
    @Override
    public long maxSize() {
        this.throwExceptionIfClosed();
        return 16L;
    }

    @Override
    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue() + ", value2: " + this.getValue2();
    }

    public long getValue2() {
        this.throwExceptionIfClosed();
        return this.bytes.readLong(this.offset + 8L);
    }

    public void setValue2(long value) {
        this.throwExceptionIfClosed();
        this.bytes.writeLong(this.offset + 8L, value);
    }

    public long getVolatileValue2() {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileLong(this.offset + 8L);
    }

    public void setVolatileValue2(long value) {
        this.throwExceptionIfClosed();
        this.bytes.writeVolatileLong(this.offset + 8L, value);
    }

    public void setOrderedValue2(long value) {
        this.throwExceptionIfClosed();
        this.bytes.writeOrderedLong(this.offset + 8L, value);
    }

    public long addValue2(long delta) {
        this.throwExceptionIfClosed();
        return this.bytes.addAndGetLong(this.offset + 8L, delta);
    }

    public long addAtomicValue2(long delta) {
        this.throwExceptionIfClosed();
        return this.addValue2(delta);
    }

    public boolean compareAndSwapValue2(long expected, long value) {
        this.throwExceptionIfClosed();
        return this.bytes.compareAndSwapLong(this.offset + 8L, expected, value);
    }
}

