/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UncheckedLongReference
extends AbstractCloseable
implements LongReference,
ReferenceOwner {
    private long address;
    private Unsafe unsafe;
    private BytesStore bytes;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        @NotNull AbstractCloseable ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        this.throwExceptionIfClosed();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.address = bytes.addressForRead(offset);
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.unsafe = UnsafeMemory.UNSAFE;
    }

    @NotNull
    public BytesStore bytesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    public long getValue() {
        this.throwExceptionIfClosed();
        return this.unsafe.getLong(this.address);
    }

    public void setValue(long value) {
        this.throwExceptionIfClosed();
        this.unsafe.putLong(this.address, value);
    }

    public long getVolatileValue() {
        this.throwExceptionIfClosed();
        return this.unsafe.getLongVolatile(null, this.address);
    }

    public long getVolatileValue(long closedValue) {
        if (this.isClosed()) {
            return closedValue;
        }
        try {
            return this.getVolatileValue();
        }
        catch (Exception e) {
            return closedValue;
        }
    }

    public void setVolatileValue(long value) {
        this.throwExceptionIfClosed();
        this.unsafe.putLongVolatile(null, this.address, value);
    }

    public void setOrderedValue(long value) {
        this.throwExceptionIfClosed();
        this.unsafe.putOrderedLong(null, this.address, value);
    }

    public long addValue(long delta) {
        this.throwExceptionIfClosed();
        return this.unsafe.getAndAddLong(null, this.address, delta) + delta;
    }

    public long addAtomicValue(long delta) {
        this.throwExceptionIfClosed();
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        this.throwExceptionIfClosed();
        return this.unsafe.compareAndSwapLong(null, this.address, expected, value);
    }

    protected void performClose() {
        this.unsafe = null;
        this.bytes.release(this);
    }

    protected boolean threadSafetyCheck() {
        return true;
    }
}

