/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.ReadOnlyMappedBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedFile
extends AbstractCloseable
implements ReferenceCounted {
    private static final long DEFAULT_CAPACITY = 0x800000000000L;
    private static final Map<String, WeakReference<NamedObject>> FILE_LOCKS = new HashMap<String, WeakReference<NamedObject>>();
    private static final int EXPUNGE_MODULO = 64;
    private static int EXPUNGE_COUNTER = 0;
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final List<WeakReference<MappedBytesStore>> stores = new ArrayList<WeakReference<MappedBytesStore>>();
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final long capacity;
    @NotNull
    private final File file;
    private final String canonicalPath;
    private final boolean readOnly;
    private NewChunkListener newChunkListener = MappedFile::logNewChunk;

    protected MappedFile(@NotNull File file, @NotNull RandomAccessFile raf, long chunkSize, long overlapSize, long capacity, boolean readOnly) {
        this.file = file;
        try {
            this.canonicalPath = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to obtain the canonical path for " + file.getAbsolutePath(), ioe);
        }
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.chunkSize = OS.mapAlign((long)chunkSize);
        this.overlapSize = overlapSize > 0L && overlapSize < 65536L ? chunkSize : OS.mapAlign((long)overlapSize);
        this.capacity = capacity;
        this.readOnly = readOnly;
        if (Jvm.isJava9Plus()) {
            this.doNotCloseOnInterrupt9(this.fileChannel);
        } else {
            this.doNotCloseOnInterrupt(this.fileChannel);
        }
    }

    private static void logNewChunk(String filename, int chunk, long delayMicros) {
        if (!Jvm.isDebugEnabled(MappedFile.class)) {
            return;
        }
        String message = BytesInternal.acquireStringBuilder().append("Allocation of ").append(chunk).append(" chunk in ").append(filename).append(" took ").append((double)delayMicros / 1000.0).append(" ms.").toString();
        Jvm.debug().on(MappedFile.class, message);
    }

    public static void checkMappedFiles() {
        AbstractCloseable.assertCloseablesClosed();
    }

    @NotNull
    public static MappedFile of(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException {
        @NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, readOnly ? "r" : "rw");
        long capacity = 0x800000000000L;
        return new MappedFile(file, (RandomAccessFile)raf, chunkSize, overlapSize, 0x800000000000L, readOnly);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(filename, chunkSize, (long)OS.pageSize());
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull String filename, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(new File(filename), chunkSize, overlapSize);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, overlapSize, false);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException {
        return MappedFile.of(file, chunkSize, overlapSize, readOnly);
    }

    @NotNull
    public static MappedFile readOnly(@NotNull File file) throws FileNotFoundException {
        long chunkSize = file.length();
        long overlapSize = 0L;
        if (OS.isWindows() && chunkSize > 0x80000000L) {
            chunkSize = 0x80000000L;
            overlapSize = OS.pageSize();
        }
        return MappedFile.of(file, chunkSize, overlapSize, true);
    }

    @NotNull
    public static MappedFile mappedFile(@NotNull File file, long capacity, long chunkSize, long overlapSize, boolean readOnly) throws IOException {
        CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, readOnly ? "r" : "rw");
        if (raf.length() < capacity) {
            raf.setLength(capacity);
        }
        return new MappedFile(file, (RandomAccessFile)raf, chunkSize, overlapSize, capacity, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmup() {
        ArrayList<IOException> errorsDuringWarmup = new ArrayList<IOException>();
        try {
            Jvm.setExceptionHandlers((ExceptionHandler)Slf4jExceptionHandler.FATAL, null, null);
            @NotNull File file = File.createTempFile("delete_warming_up", "me");
            file.deleteOnExit();
            long mapAlignment = OS.mapAlignment();
            int chunks = 64;
            int compileThreshold = Jvm.compileThreshold();
            for (int j = 0; j <= compileThreshold; j += 64) {
                try {
                    try (@NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, "rw");){
                        @NotNull MappedFile mappedFile = new MappedFile(file, (RandomAccessFile)raf, mapAlignment, 0L, mapAlignment * 64L, false);
                        MappedFile.warmup0(mapAlignment, 64, mappedFile);
                        mappedFile.release();
                    }
                    Thread.yield();
                    continue;
                }
                catch (IOException e) {
                    errorsDuringWarmup.add(e);
                }
            }
            Thread.yield();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            Jvm.resetExceptionHandlers();
            Jvm.warn().on(MappedFile.class, "Error during warmup", (Throwable)e);
        }
        finally {
            Jvm.resetExceptionHandlers();
            if (errorsDuringWarmup.size() > 0) {
                Jvm.warn().on(MappedFile.class, errorsDuringWarmup.size() + " errors during warmup: " + errorsDuringWarmup);
            }
        }
    }

    private static void warmup0(long mapAlignment, int chunks, @NotNull MappedFile mappedFile) throws IOException {
        for (int i = 0; i < chunks; ++i) {
            mappedFile.acquireBytesForRead((long)i * mapAlignment).release();
            mappedFile.acquireBytesForWrite((long)i * mapAlignment).release();
        }
    }

    private void doNotCloseOnInterrupt(FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Jvm.setAccessible((AccessibleObject)field);
            field.set(fc, thread -> System.err.println(((Object)((Object)this)).getClass().getName() + " - " + fc + " not closed on interrupt"));
        }
        catch (Throwable e) {
            Jvm.warn().on(((Object)((Object)this)).getClass(), "Couldn't disable close on interrupt", e);
        }
    }

    private void doNotCloseOnInterrupt9(FileChannel fc) {
        try {
            Field field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            Class<?> interruptibleClass = field.getType();
            Jvm.setAccessible((AccessibleObject)field);
            field.set(fc, Proxy.newProxyInstance(interruptibleClass.getClassLoader(), new Class[]{interruptibleClass}, (p, m, a) -> {
                System.err.println(((Object)((Object)this)).getClass().getName() + " - " + fc + " not closed on interrupt");
                return null;
            }));
        }
        catch (Throwable e) {
            Jvm.warn().on(((Object)((Object)this)).getClass(), "Couldn't disable close on interrupt", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MappedFile withSizes(long chunkSize, long overlapSize) {
        chunkSize = OS.mapAlign((long)chunkSize);
        overlapSize = OS.mapAlign((long)overlapSize);
        if (chunkSize == this.chunkSize && overlapSize == this.overlapSize) {
            return this;
        }
        try {
            MappedFile mappedFile = new MappedFile(this.file, this.raf, chunkSize, overlapSize, this.capacity, this.readOnly);
            return mappedFile;
        }
        finally {
            this.release();
        }
    }

    @NotNull
    public File file() {
        return this.file;
    }

    @NotNull
    public MappedBytesStore acquireByteStore(long position) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.acquireByteStore(position, this.readOnly ? ReadOnlyMappedBytesStore::new : MappedBytesStore::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MappedBytesStore acquireByteStore(long position, @NotNull MappedBytesStoreFactory mappedBytesStoreFactory) throws IOException, IllegalArgumentException, IllegalStateException {
        MappedBytesStore mbs;
        WeakReference<MappedBytesStore> mbsRef;
        this.throwExceptionIfClosed();
        if (position < 0L) {
            throw new IOException("Attempt to access a negative position: " + position);
        }
        int chunk = (int)(position / this.chunkSize);
        Jvm.safepoint();
        List<WeakReference<MappedBytesStore>> list = this.stores;
        synchronized (list) {
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            mbsRef = this.stores.get(chunk);
        }
        if (mbsRef != null && (mbs = (MappedBytesStore)mbsRef.get()) != null && mbs.tryReserve()) {
            return mbs;
        }
        this.resizeRafIfTooSmall(chunk);
        list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs2;
            WeakReference<MappedBytesStore> mbsRef2 = this.stores.get(chunk);
            if (mbsRef2 != null && (mbs2 = (MappedBytesStore)mbsRef2.get()) != null && mbs2.tryReserve()) {
                return mbs2;
            }
            long mappedSize = this.chunkSize + this.overlapSize;
            FileChannel.MapMode mode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            long startOfMap = (long)chunk * this.chunkSize;
            long beginNs = System.nanoTime();
            long address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)mode, (long)startOfMap, (long)mappedSize);
            MappedBytesStore mbs22 = mappedBytesStoreFactory.create(this, (long)chunk * this.chunkSize, address, mappedSize, this.chunkSize);
            this.stores.set(chunk, new WeakReference<MappedBytesStore>(mbs22));
            long elapsedNs = System.nanoTime() - beginNs;
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file.getPath(), chunk, elapsedNs / 1000L);
            }
            if (elapsedNs > 5000000L) {
                Jvm.warn().on(((Object)((Object)this)).getClass(), "Took " + elapsedNs / 1000L + " us to add mapping for " + this.file());
            }
            return mbs22;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeRafIfTooSmall(int chunk) throws IOException {
        Jvm.safepoint();
        long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
        long size = this.fileChannel.size();
        Jvm.safepoint();
        if (size >= minSize || this.readOnly) {
            return;
        }
        try {
            NamedObject namedObject;
            Object object = FILE_LOCKS;
            synchronized (object) {
                if (++EXPUNGE_COUNTER % 64 == 0) {
                    Set<String> expiredKeys = FILE_LOCKS.entrySet().stream().filter(e -> ((WeakReference)e.getValue()).get() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
                    expiredKeys.forEach(FILE_LOCKS::remove);
                }
                do {
                    WeakReference namedObjectRef;
                    if ((namedObject = (NamedObject)(namedObjectRef = FILE_LOCKS.computeIfAbsent(this.canonicalPath, k -> new WeakReference<NamedObject>(new NamedObject((String)k)))).get()) != null) continue;
                    FILE_LOCKS.remove(this.canonicalPath);
                } while (namedObject == null);
            }
            object = namedObject;
            synchronized (object) {
                size = this.fileChannel.size();
                if (size < minSize) {
                    long beginNs = System.nanoTime();
                    try (FileLock ignore = this.fileChannel.lock();){
                        size = this.fileChannel.size();
                        if (size < minSize) {
                            Jvm.safepoint();
                            this.raf.setLength(minSize);
                            Jvm.safepoint();
                        }
                    }
                    long elapsedNs = System.nanoTime() - beginNs;
                    if (elapsedNs >= 1000000L) {
                        Jvm.warn().on(((Object)((Object)this)).getClass(), "Took " + elapsedNs / 1000L + " us to grow file " + this.file());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Failed to resize to " + minSize, ioe);
        }
    }

    @NotNull
    public Bytes acquireBytesForRead(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        @Nullable MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes bytes = mbs.bytesForRead();
        bytes.readPositionUnlimited(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForRead(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        @Nullable MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
    }

    @NotNull
    public Bytes acquireBytesForWrite(long position) throws IOException, IllegalStateException, IllegalArgumentException {
        @Nullable MappedBytesStore mbs = this.acquireByteStore(position);
        @NotNull Bytes bytes = mbs.bytesForWrite();
        bytes.writePosition(position);
        mbs.release();
        return bytes;
    }

    public void acquireBytesForWrite(long position, @NotNull VanillaBytes bytes) throws IOException, IllegalStateException, IllegalArgumentException {
        @Nullable MappedBytesStore mbs = this.acquireByteStore(position);
        bytes.bytesStore(mbs, position, mbs.capacity() - position);
        bytes.writePosition(position);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.refCount();
    }

    public boolean tryReserve() {
        return this.refCount.tryReserve();
    }

    protected void performClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRelease() {
        try {
            List<WeakReference<MappedBytesStore>> list = this.stores;
            synchronized (list) {
                for (int i = 0; i < this.stores.size(); ++i) {
                    WeakReference<MappedBytesStore> storeRef = this.stores.get(i);
                    if (storeRef == null) continue;
                    @Nullable MappedBytesStore mbs = (MappedBytesStore)storeRef.get();
                    if (mbs != null) {
                        while (mbs.refCount() != 0L) {
                            try {
                                mbs.release();
                            }
                            catch (IllegalStateException e) {
                                Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
                            }
                        }
                    }
                    storeRef.clear();
                    this.stores.set(i, null);
                }
            }
        }
        finally {
            Closeable.closeQuietly((Object)this.raf);
            this.close();
        }
    }

    @NotNull
    public String referenceCounts() {
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (WeakReference<MappedBytesStore> store : this.stores) {
            MappedBytesStore mbs;
            long count = 0L;
            if (store != null && (mbs = (MappedBytesStore)store.get()) != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    public long capacity() {
        return this.capacity;
    }

    public long chunkSize() {
        return this.chunkSize;
    }

    public long overlapSize() {
        return this.overlapSize;
    }

    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    public long actualSize() throws IORuntimeException {
        boolean interrupted = Thread.interrupted();
        try {
            long l = this.fileChannel.size();
            return l;
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            long l = this.actualSize();
            return l;
        }
        catch (ClosedByInterruptException cbie) {
            this.close();
            interrupted = true;
            throw new IllegalStateException(cbie);
        }
        catch (IOException e) {
            boolean open = this.fileChannel.isOpen();
            if (open) {
                throw new IORuntimeException((Throwable)e);
            }
            this.close();
            throw new IllegalStateException(e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    public RandomAccessFile raf() {
        return this.raf;
    }

    protected void finalize() throws Throwable {
        this.warnIfNotClosed();
        this.close();
        super.finalize();
    }

    private static final class NamedObject {
        private final String name;

        public NamedObject(@NotNull String name) {
            this.name = name;
        }

        public String toString() {
            return "NamedObject{name='" + this.name + '\'' + '}';
        }
    }
}

