/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesMethodWriterInvocationHandler;
import net.openhft.chronicle.core.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class BytesMethodWriterBuilder<T>
implements Supplier<T> {
    private final List<Class> interfaces = new ArrayList<Class>();
    @NotNull
    private final BytesMethodWriterInvocationHandler handler;
    private ClassLoader classLoader;

    public BytesMethodWriterBuilder(@NotNull Class<T> tClass, @NotNull BytesMethodWriterInvocationHandler handler) {
        this.interfaces.add(Closeable.class);
        this.interfaces.add(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handler = handler;
    }

    @NotNull
    public BytesMethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public BytesMethodWriterBuilder<T> addInterface(Class additionalClass) {
        this.interfaces.add(additionalClass);
        return this;
    }

    @NotNull
    public BytesMethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handler.onClose(closeable);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    @Override
    @NotNull
    public T get() {
        Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
    }
}

