/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBytes
implements Bytes {
    private static final int NUMBER_WRAP = 16;
    private static final int COMMENT_START = 48;
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]{1,2}");
    private final Bytes base = Bytes.elasticHeapByteBuffer(128);
    private final Bytes text = Bytes.elasticHeapByteBuffer(128);
    private final Bytes comment = Bytes.elasticHeapByteBuffer(64);
    private long startOfLine = 0L;
    private int indent = 0;

    public TextBytes() {
    }

    TextBytes(BytesStore base, Bytes text) {
        this.base.write(base);
        this.text.write(text);
    }

    public static TextBytes fromText(Reader reader) {
        TextBytes tb = new TextBytes();
        TextBytesReader reader2 = new TextBytesReader(reader, tb.text);
        try (Scanner sc = new Scanner(reader2);){
            while (sc.hasNext()) {
                if (sc.hasNext(HEX_PATTERN)) {
                    tb.base.writeUnsignedByte(Integer.parseInt(sc.next(), 16));
                    continue;
                }
                sc.nextLine();
            }
        }
        return tb;
    }

    public static TextBytes fromText(CharSequence text) {
        return TextBytes.fromText(new StringReader(text.toString()));
    }

    @Override
    @NotNull
    public String toHexString() {
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this.text.toString();
    }

    @Override
    public boolean retainsComments() {
        return true;
    }

    public Bytes comment(CharSequence comment) {
        if (this.comment.readRemaining() > 0L || comment.length() == 0) {
            this.newLine();
        }
        this.comment.clear().append(comment);
        return this;
    }

    @Override
    public BytesOut indent(int n) {
        this.indent += n;
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this;
    }

    private long lineLength() {
        return this.text.writePosition() - this.startOfLine;
    }

    private void newLine() {
        if (this.comment.readRemaining() > 0L) {
            while (this.lineLength() < 46L) {
                this.text.append("   ");
            }
            while (this.lineLength() < 48L) {
                this.text.append(' ');
            }
            this.text.append("# ");
            this.text.append(this.comment);
            this.comment.clear();
        }
        this.text.append('\n');
        this.startOfLine = this.text.writePosition();
    }

    @Override
    public BytesStore copy() {
        return new TextBytes(this.base, this.text);
    }

    @Override
    public boolean isElastic() {
        return this.base.isElastic();
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        this.base.ensureCapacity(size);
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this;
    }

    @NotNull
    public Bytes compact() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes clear() {
        return this.base.clear();
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public long capacity() {
        return this.base.capacity();
    }

    @Override
    public long address(long offset) throws UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Object underlyingObject() {
        return this.base.underlyingObject();
    }

    @Override
    public void move(long from, long to, long length) {
        throw new UnsupportedOperationException();
    }

    public void reserve() throws IllegalStateException {
        this.base.reserve();
    }

    public void release() throws IllegalStateException {
        this.base.release();
    }

    public long refCount() {
        return this.base.refCount();
    }

    @Override
    @NotNull
    public RandomDataOutput writeByte(long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeShort(long offset, short i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeInt24(long offset, int i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeInt(long offset, int i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeOrderedInt(long offset, int i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeLong(long offset, long i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeOrderedLong(long offset, long i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeFloat(long offset, float d) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeDouble(long offset, double d) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RandomDataOutput write(long offsetInRDO, RandomDataInput bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public StreamingDataInput readPosition(long position) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public StreamingDataInput readLimit(long limit) throws BufferUnderflowException {
        return this.base.readLimit(limit);
    }

    @Override
    @NotNull
    public StreamingDataInput readSkip(long bytesToSkip) throws BufferUnderflowException {
        return this.base.readSkip(bytesToSkip);
    }

    @Override
    public void uncheckedReadSkipOne() {
        this.base.uncheckedReadSkipOne();
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        this.base.uncheckedReadSkipBackOne();
    }

    @Override
    public byte readByte() {
        return this.base.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.base.readUnsignedByte();
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.base.uncheckedReadUnsignedByte();
    }

    @Override
    public short readShort() throws BufferUnderflowException {
        return this.base.readShort();
    }

    @Override
    public int readInt() throws BufferUnderflowException {
        return this.base.readInt();
    }

    @Override
    public long readLong() throws BufferUnderflowException {
        return this.base.readLong();
    }

    @Override
    public float readFloat() throws BufferUnderflowException {
        return this.base.readFloat();
    }

    @Override
    public double readDouble() throws BufferUnderflowException {
        return this.base.readDouble();
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException {
        return this.base.readVolatileInt();
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException {
        return this.base.readVolatileLong();
    }

    @Override
    public int peekUnsignedByte() {
        return this.base.peekUnsignedByte();
    }

    @Override
    public void nativeRead(long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(address, size);
    }

    @Override
    public int lastDecimalPlaces() {
        return this.base.lastDecimalPlaces();
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.base.lastDecimalPlaces(lastDecimalPlaces);
    }

    @Override
    @NotNull
    public StreamingDataOutput writePosition(long position) throws BufferOverflowException {
        return this.base.writePosition(position);
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeLimit(long limit) throws BufferOverflowException {
        return this.base.writeLimit(limit);
    }

    @Override
    @NotNull
    public StreamingDataOutput writeSkip(long bytesToSkip) throws BufferOverflowException {
        return this.base.writeSkip(bytesToSkip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeByte(byte i8) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeByte(i8);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public long writePosition() {
        return this.base.writePosition();
    }

    private void copyToText(long pos) {
        if (pos < this.writePosition()) {
            this.doIndent();
            do {
                int value = this.base.readUnsignedByte(pos++);
                if (this.lineLength() >= 47L) {
                    this.newLine();
                    this.doIndent();
                }
                if (this.lineLength() > 0L) {
                    this.text.append(' ');
                }
                if (value < 16) {
                    this.text.append('0');
                }
                this.text.appendBase(value, 16);
            } while (pos < this.writePosition());
        }
    }

    private void doIndent() {
        if (this.lineLength() == 0L && this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.text.append("   ");
            }
            this.startOfLine = this.text.writePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeShort(short i16) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeShort(i16);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeInt(int i) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeInt(i);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeIntAdv(int i, int advance) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeIntAdv(i, advance);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeLong(long i64) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeLong(i64);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeLongAdv(long i64, int advance) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeLongAdv(i64, advance);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeFloat(float f) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeFloat(f);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeDouble(double d) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeDouble(d);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.write(bytes, offset, length);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeSome(ByteBuffer buffer) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeSome(buffer);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeOrderedInt(int i) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeOrderedInt(i);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public StreamingDataOutput writeOrderedLong(long i) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            StreamingDataOutput streamingDataOutput = this.base.writeOrderedLong(i);
            return streamingDataOutput;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nativeWrite(long address, long size) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            this.base.nativeWrite(address, size);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BytesPrepender clearAndPad(long length) throws BufferOverflowException {
        long pos = this.writePosition();
        try {
            BytesPrepender bytesPrepender = this.base.clearAndPad(length);
            return bytesPrepender;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public BytesPrepender prewrite(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BytesPrepender prewrite(BytesStore bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BytesPrepender prewriteByte(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BytesPrepender prewriteShort(short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BytesPrepender prewriteInt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BytesPrepender prewriteLong(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        return this.base.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(long offset) {
        return this.base.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        return this.base.readShort(offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        return this.base.readInt(offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        return this.base.readLong(offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        return this.base.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        return this.base.readDouble(offset);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        return this.base.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        return this.base.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        return this.base.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        return this.base.readVolatileLong(offset);
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(position, address, size);
    }

    private static class TextBytesReader
    extends Reader {
        private final Reader reader;
        private final Bytes base;

        public TextBytesReader(Reader reader, Bytes base) {
            this.reader = reader;
            this.base = base;
        }

        @Override
        public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
            int len2 = this.reader.read(cbuf, off, len);
            this.base.append(new String(cbuf, off, len));
            return len2;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

