/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ExpectedBytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
BytesIn<Underlying>,
BytesOut<Underlying> {
    public static final long MAX_CAPACITY = Long.MAX_VALUE;
    public static final int DEFAULT_BYTE_BUFFER_CAPACITY = 256;

    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return Bytes.elasticByteBuffer(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity, int maxSize) {
        NativeBytesStore<ByteBuffer> bs = NativeBytesStore.elasticByteBuffer(initialCapacity, maxSize);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity) {
        return Bytes.elasticByteBuffer(initialCapacity, Integer.MAX_VALUE & ~(OS.pageSize() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> wrapForRead(ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForRead();
            bbb.readLimit(byteBuffer.limit());
            bbb.readPosition(byteBuffer.position());
            Bytes<ByteBuffer> bytes = bbb;
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> wrapForWrite(ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForWrite();
            bbb.writePosition(byteBuffer.position());
            bbb.writeLimit(byteBuffer.limit());
            Bytes<ByteBuffer> bytes = bbb;
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    @NotNull
    public static Bytes<byte[]> expect(@NotNull String text) {
        return Bytes.expect(Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1)));
    }

    @NotNull
    public static <B extends BytesStore<B, Underlying>, Underlying> Bytes<Underlying> expect(BytesStore<B, Underlying> bytesStore) {
        return new VanillaBytes(new ExpectedBytesStore<B, Underlying>(bytesStore));
    }

    public static Bytes<byte[]> wrapForRead(byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> wrapForWrite(byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> from(@NotNull CharSequence text) throws IllegalArgumentException, IllegalStateException {
        if (text instanceof BytesStore) {
            return ((BytesStore)text).copy().bytesForRead();
        }
        return Bytes.wrapForRead(text.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    @Deprecated
    public static Bytes<byte[]> wrapForRead(@NotNull CharSequence text) throws IllegalArgumentException, IllegalStateException {
        return Bytes.from(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VanillaBytes<Void> allocateDirect(long capacity) throws IllegalArgumentException {
        NativeBytesStore<Void> bs = NativeBytesStore.nativeStoreWithFixedCapacity(capacity);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    public static NativeBytes<Void> allocateElasticDirect(long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(initialCapacity);
    }

    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException {
        return Bytes.toString(buffer, 0x7FFFFFFBL);
    }

    public static String toString(@NotNull Bytes<?> buffer, long maxLen) throws BufferUnderflowException {
        if (buffer.readRemaining() == 0L) {
            return "";
        }
        long length = Math.min(maxLen + 1L, buffer.readRemaining());
        StringBuilder builder = new StringBuilder();
        try {
            buffer.readWithLength(length, b -> {
                while (buffer.readRemaining() > 0L) {
                    if ((long)builder.length() >= maxLen) {
                        builder.append("...");
                        break;
                    }
                    builder.append((char)buffer.readByte());
                }
            });
        }
        catch (Exception e) {
            builder.append(' ').append(e);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@NotNull Bytes buffer, long position, long len) throws BufferUnderflowException {
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPositionRemaining(position, len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.readLimit(limit);
            buffer.readPosition(pos);
        }
    }

    public static Bytes allocateDirect(@NotNull byte[] bytes) throws IllegalArgumentException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        try {
            result.write(bytes);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static Bytes fromHexString(String s) {
        return BytesInternal.fromHexString(s);
    }

    default public Bytes<Underlying> unchecked(boolean unchecked) throws IllegalStateException {
        return unchecked ? (this.start() == 0L && this.bytesStore().isDirectMemory() ? new UncheckedNativeBytes(this) : new UncheckedBytes(this)) : this;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy();

    @NotNull
    default public String toHexString() {
        return this.toHexString(1024L);
    }

    @NotNull
    default public String toHexString(long maxLength) {
        return this.toHexString(this.readPosition(), maxLength);
    }

    @NotNull
    default public String toHexString(long offset, long maxLength) {
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        String ret = BytesInternal.toHexString(this, offset, maxLength2);
        return maxLength2 < this.readLimit() - offset ? ret + "... truncated" : ret;
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) throws IllegalArgumentException {
        if (size > this.capacity()) {
            throw new IllegalArgumentException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return this.isClear() ? BytesStore.super.bytesForRead() : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
    }

    @Override
    public BytesStore bytesStore();

    default public boolean isEqual(String s) {
        return StringUtils.isEqual((CharSequence)this, (CharSequence)s);
    }

    public Bytes<Underlying> compact();

    @Override
    default public long copyTo(@NotNull BytesStore store) {
        return BytesStore.super.copyTo(store);
    }

    @Override
    default public void copyTo(OutputStream out) throws IOException {
        BytesStore.super.copyTo(out);
    }

    @Override
    default public boolean sharedMemory() {
        return this.bytesStore().sharedMemory();
    }

    default public void unwrite(long fromOffset, int count) {
        this.write(fromOffset, this, fromOffset + (long)count, this.readRemaining() - 1L);
        this.writeSkip(-count);
    }
}

