/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.LongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;
    private static Set<WeakReference<BinaryLongReference>> binaryLongReferences;
    private BytesStore bytes;
    private long offset;

    public static void startCollecting() {
        binaryLongReferences = new CopyOnWriteArraySet<WeakReference<BinaryLongReference>>();
    }

    public static void forceAllToNotCompleteState() {
        binaryLongReferences.forEach(x -> {
            BinaryLongReference binaryLongReference = (BinaryLongReference)x.get();
            if (binaryLongReference != null) {
                binaryLongReference.setValue(-1L);
            }
        });
        binaryLongReferences = null;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes.bytesStore();
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.bytes.readLong(this.offset);
    }

    public void setValue(long value) {
        this.bytes.writeLong(this.offset, value);
    }

    public long getVolatileValue() {
        return this.bytes.readVolatileLong(this.offset);
    }

    public void setOrderedValue(long value) {
        this.bytes.writeOrderedLong(this.offset, value);
    }

    public long addValue(long delta) {
        return this.bytes.addAndGetLong(this.offset, delta);
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        if (value == -1L && binaryLongReferences != null) {
            binaryLongReferences.add(new WeakReference<BinaryLongReference>(this));
        }
        return this.bytes.compareAndSwapLong(this.offset, expected, value);
    }
}

