/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VanillaBytes<Underlying>
extends AbstractBytes<Underlying>
implements Byteable<Bytes<Underlying>, Underlying> {
    public VanillaBytes(@NotNull BytesStore bytesStore) throws IllegalStateException {
        this(bytesStore, bytesStore.writePosition(), bytesStore.writeLimit());
    }

    public VanillaBytes(@NotNull BytesStore bytesStore, long writePosition, long writeLimit) throws IllegalStateException {
        super(bytesStore, writePosition, writeLimit);
    }

    @NotNull
    public static VanillaBytes<Void> vanillaBytes() {
        try {
            return new VanillaBytes<Void>(NoBytesStore.noBytesStore());
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isEqual0(char[] chars, NativeBytesStore bs, long address) {
        int b;
        int i;
        long start = System.nanoTime();
        Memory memory = bs.memory;
        for (i = 0; i < chars.length - 3; i += 4) {
            b = memory.readInt(address + (long)i);
            int b0 = b & 0xFF;
            int b1 = b >> 8 & 0xFF;
            int b2 = b >> 16 & 0xFF;
            int b3 = b >> 24 & 0xFF;
            if (b0 == chars[i] && b1 == chars[i + 1] && b2 == chars[i + 2] && b3 == chars[i + 3]) continue;
            return false;
        }
        while (i < chars.length) {
            b = memory.readByte(address + (long)i) & 0xFF;
            if (b != chars[i]) {
                return false;
            }
            ++i;
        }
        long time = System.nanoTime() - start;
        if ((double)time > 1000000.0) {
            System.out.println("isEquals took " + (double)time / 1000000.0 + " ms. len=" + chars.length);
        }
        return true;
    }

    private static boolean isEqual1(char[] chars, BytesStore bytesStore, long readPosition) {
        for (int i = 0; i < chars.length; ++i) {
            int b = bytesStore.readByte(readPosition + (long)i) & 0xFF;
            if (b == chars[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> byteStore, long offset, long length) throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        this.bytesStore(byteStore);
        this.readLimit(offset + length);
        this.writeLimit(offset + length);
        this.readPosition(offset);
    }

    private void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) throws IllegalStateException {
        BytesStore oldBS = this.bytesStore;
        this.bytesStore = bytesStore;
        bytesStore.reserve();
        oldBS.release();
        this.clear();
    }

    @Override
    public long offset() {
        return this.readPosition();
    }

    @Override
    public long maxSize() {
        return this.readRemaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    @NotNull
    public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return this.isClear() ? new VanillaBytes<Underlying>(this.bytesStore, this.writePosition(), this.bytesStore.writeLimit()) : new SubBytes(this.bytesStore, this.readPosition(), this.readLimit());
    }

    @Override
    public boolean isEqual(String s) {
        if (s == null || (long)s.length() != this.readRemaining()) {
            return false;
        }
        char[] chars = StringUtils.extractChars((String)s);
        if (this.bytesStore instanceof NativeBytesStore) {
            NativeBytesStore bs = (NativeBytesStore)this.bytesStore;
            long address = bs.address + bs.translate(this.readPosition);
            return VanillaBytes.isEqual0(chars, bs, address);
        }
        try {
            return VanillaBytes.isEqual1(chars, this.bytesStore, this.readPosition);
        }
        catch (IORuntimeException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.readRemaining()));
            ByteBuffer bbu = (ByteBuffer)this.bytesStore.underlyingObject();
            ByteBuffer slice = bbu.slice();
            slice.position((int)this.readPosition());
            slice.limit((int)this.readLimit());
            bb.put(slice);
            bb.clear();
            return BytesStore.wrap(bb);
        }
        return NativeBytes.copyOf(this);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException, IORuntimeException {
        if (this.bytesStore() instanceof NativeBytesStore && bytes.bytesStore() instanceof NativeBytesStore && length >= 64L) {
            long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
            if (len > 0L) {
                this.writeCheckOffset(this.writePosition(), len);
                OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
                this.writeSkip(len);
            }
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    public void write(long position, @NotNull CharSequence str, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        if (!(str instanceof String)) {
            throw new UnsupportedOperationException();
        }
        char[] chars = ((String)str).toCharArray();
        this.ensureCapacity(position + (long)length);
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
        nbs.write8bit(position, chars, offset, length);
    }

    @Override
    @NotNull
    public VanillaBytes append(@NotNull CharSequence str, int start, int end) throws IndexOutOfBoundsException {
        try {
            if (this.bytesStore() instanceof NativeBytesStore) {
                if (str instanceof BytesStore) {
                    this.write((BytesStore)str, (long)start, (long)(end - start));
                    return this;
                }
                if (str instanceof String) {
                    this.write(str, start, end - start);
                    return this;
                }
            }
            super.append(str, start, end);
            return this;
        }
        catch (Exception e) {
            throw new IndexOutOfBoundsException(e.toString());
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return (Bytes)this.write((BytesStore)cs);
        }
        if (this.bytesStore instanceof NativeBytesStore && cs instanceof String) {
            return this.append8bitNBS_S((String)cs);
        }
        return this.append8bit0(cs);
    }

    private Bytes<Underlying> append8bitNBS_S(String s) {
        int length = s.length();
        long offset = this.writeOffsetPositionMoved(length);
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(offset);
        Memory memory = bytesStore.memory;
        char[] chars = StringUtils.extractChars((String)s);
        if (memory == null) {
            throw new AssertionError((Object)bytesStore.releasedHere);
        }
        for (int i = 0; i < length; ++i) {
            int c = chars[i];
            if (c > 255) {
                c = 63;
            }
            memory.writeByte(address + (long)i, (byte)c);
        }
        return this;
    }

    @Override
    public String toString() {
        return this.bytesStore instanceof NativeBytesStore ? this.toString2((NativeBytesStore)this.bytesStore) : this.toString0();
    }

    private String toString2(NativeBytesStore bytesStore) {
        int length = Maths.toUInt31((long)this.readRemaining());
        char[] chars = new char[length];
        Memory memory = bytesStore.memory;
        long address = bytesStore.address + bytesStore.translate(this.readPosition());
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(memory.readByte(address + (long)i) & 0xFF);
        }
        return StringUtils.newString((char[])chars);
    }

    protected String toString0() {
        int length = Maths.toUInt31((long)this.readRemaining());
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.bytesStore.readByte(this.readPosition() + (long)i) & 0xFF);
        }
        return StringUtils.newString((char[])chars);
    }

    @NotNull
    protected Bytes<Underlying> append8bit0(@NotNull CharSequence cs) {
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.bytesStore.writeByte(offset + (long)i, (byte)c);
        }
        return this;
    }

    @Override
    public boolean equalBytes(BytesStore bytesStore, long length) throws BufferUnderflowException, IORuntimeException {
        if (this.bytesStore instanceof NativeBytesStore && bytesStore instanceof VanillaBytes && bytesStore.bytesStore() instanceof NativeBytesStore) {
            long i;
            VanillaBytes b2 = (VanillaBytes)bytesStore;
            NativeBytesStore nbs0 = (NativeBytesStore)this.bytesStore;
            NativeBytesStore nbs2 = (NativeBytesStore)b2.bytesStore();
            for (i = 0L; i < length - 7L; ++i) {
                long l2;
                long addr0 = nbs0.address + this.readPosition() - nbs0.start() + i;
                long addr2 = nbs2.address + b2.readPosition() - nbs2.start() + i;
                long l0 = nbs0.memory.readLong(addr0);
                if (l0 == (l2 = nbs2.memory.readLong(addr2))) continue;
                return false;
            }
            while (i < length) {
                byte b1;
                long offset2 = this.readPosition() + i - nbs0.start();
                long offset21 = b2.readPosition() + i - nbs2.start();
                byte b0 = nbs0.memory.readByte(nbs0.address + offset2);
                if (b0 != (b1 = nbs2.memory.readByte(nbs2.address + offset21))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equalBytes(bytesStore, length);
    }

    public void read8Bit(char[] chars, int length) {
        long position = this.readPosition();
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore();
        nbs.read8bit(position, chars, length);
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        if (this.readLimit() >= Integer.MAX_VALUE || this.start() != 0L || !(this.bytesStore() instanceof NativeBytesStore)) {
            return super.byteCheckSum();
        }
        int b = 0;
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore();
        Memory memory = bytesStore.memory;
        assert (memory != null);
        int lim = (int)this.readLimit();
        for (int i = (int)this.readPosition(); i < lim; ++i) {
            b = (byte)(b + memory.readByte(bytesStore.address + (long)i));
        }
        return b & 0xFF;
    }

    @Override
    public VanillaBytes<Underlying> appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.ensureCapacity(this.writePosition() + (long)length);
        if (this.bytesStore instanceof NativeBytesStore) {
            this.writePosition(((NativeBytesStore)this.bytesStore).appendUTF(this.writePosition(), chars, offset, length));
        } else {
            super.appendUtf8(chars, offset, length);
        }
        return this;
    }

    @Override
    public ByteBuffer toTemporaryDirectByteBuffer() {
        if (this.isClear()) {
            return this.bytesStore.toTemporaryDirectByteBuffer();
        }
        return super.toTemporaryDirectByteBuffer();
    }
}

