/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Reader;
import java.math.BigDecimal;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringReader;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface ByteStringParser<B extends ByteStringParser<B>>
extends StreamingDataInput<B> {
    @NotNull
    default public Reader reader() {
        return new ByteStringReader(this);
    }

    @Nullable
    default public Boolean parseBoolean(@NotNull StopCharTester tester) {
        return BytesInternal.parseBoolean(this, tester);
    }

    @ForceInline
    @NotNull
    default public String parseUtf8(@NotNull StopCharTester stopCharTester) {
        return BytesInternal.parseUtf8(this, stopCharTester);
    }

    @Deprecated
    @NotNull
    default public String parseUTF(@NotNull StopCharTester stopCharTester) {
        return this.parseUtf8(stopCharTester);
    }

    @ForceInline
    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharTester);
    }

    @Deprecated
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException {
        this.parseUtf8(buffer, stopCharTester);
    }

    @ForceInline
    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, IORuntimeException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharsTester);
    }

    @Deprecated
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, IORuntimeException {
        this.parseUtf8(buffer, stopCharsTester);
    }

    @ForceInline
    default public void parse8bit(Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharTester);
        }
    }

    @ForceInline
    default public void parse8bit(Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharsTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharsTester);
        }
    }

    default public void parse8bit(Bytes buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public void parse8bit(StringBuilder buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    @ForceInline
    default public long parseLong() throws BufferUnderflowException {
        return BytesInternal.parseLong(this);
    }

    @ForceInline
    default public double parseDouble() throws BufferUnderflowException {
        return BytesInternal.parseDouble(this);
    }

    default public long parseLongDecimal() throws BufferUnderflowException {
        return BytesInternal.parseLongDecimal(this);
    }

    public int lastDecimalPlaces();

    public void lastDecimalPlaces(int var1);

    @ForceInline
    default public boolean skipTo(@NotNull StopCharTester tester) {
        return BytesInternal.skipTo(this, tester);
    }

    @NotNull
    default public BigDecimal parseBigDecimal() {
        return new BigDecimal(this.parseUtf8(StopCharTesters.NUMBER_END));
    }
}

