/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes<Underlying>
implements Bytes<Underlying> {
    @UsedViaReflection
    private final String name;
    @NotNull
    protected BytesStore<Bytes<Underlying>, Underlying> bytesStore;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;
    protected boolean isPresent;
    private int lastDecimalPlaces = 0;
    private boolean lenient = false;

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit) throws IllegalStateException {
        this(bytesStore, writePosition, writeLimit, "");
    }

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit, String name) throws IllegalStateException {
        this.bytesStore = bytesStore;
        bytesStore.reserve();
        this.readPosition = bytesStore.readPosition();
        this.uncheckedWritePosition(writePosition);
        this.writeLimit = writeLimit;
        this.name = name;
        assert (!bytesStore.isDirectMemory() || BytesUtil.register(this));
    }

    @Override
    public boolean isDirectMemory() {
        return this.bytesStore.isDirectMemory();
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException {
        long start = this.start();
        this.bytesStore.move(from - start, to - start, length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> compact() {
        long start = this.start();
        long readRemaining = this.readRemaining();
        if (readRemaining > 0L && start < this.readPosition) {
            this.bytesStore.move(this.readPosition, start, readRemaining);
            this.readPosition = start;
            this.uncheckedWritePosition(this.readPosition + readRemaining);
        }
        return this;
    }

    @Override
    public void isPresent(boolean isPresent) {
        this.clear();
        this.isPresent = isPresent;
    }

    @Override
    public boolean isPresent() {
        return this.isPresent;
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() {
        long start;
        this.readPosition = start = this.start();
        this.uncheckedWritePosition(start);
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> clearAndPad(long length) throws BufferOverflowException {
        long l;
        if (this.start() + length > this.capacity()) {
            throw new DecoratedBufferOverflowException(String.format("clearAndPad failed. Start: %d + length: %d > capacity: %d", this.start(), length, this.capacity()));
        }
        this.readPosition = l = this.start() + length;
        this.uncheckedWritePosition(l);
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) throws BufferUnderflowException {
        if (position < this.start()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d < start: %d", position, this.start()));
        }
        if (position > this.readLimit()) {
            throw new DecoratedBufferUnderflowException(String.format("readPosition failed. Position: %d > readLimit: %d", position, this.readLimit()));
        }
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) throws BufferUnderflowException {
        if (limit < this.start()) {
            throw this.limitLessThanStart(limit);
        }
        if (limit > this.writeLimit()) {
            throw this.limitGreaterThanWriteLimit(limit);
        }
        this.uncheckedWritePosition(limit);
        return this;
    }

    private DecoratedBufferUnderflowException limitGreaterThanWriteLimit(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d > writeLimit: %d", limit, this.writeLimit()));
    }

    private DecoratedBufferUnderflowException limitLessThanStart(long limit) {
        return new DecoratedBufferUnderflowException(String.format("readLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) throws BufferOverflowException {
        if (position > this.writeLimit()) {
            throw this.writePositionTooLarge(position);
        }
        if (position < this.start()) {
            throw this.writePositionTooSmall(position);
        }
        if (position < this.readPosition()) {
            this.readPosition = position;
        }
        this.uncheckedWritePosition(position);
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writePositionTooSmall(long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d < start: %d", position, this.start()));
    }

    private DecoratedBufferOverflowException writePositionTooLarge(long position) {
        return new DecoratedBufferOverflowException(String.format("writePosition failed. Position: %d > writeLimit: %d", position, this.writeLimit()));
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) throws BufferUnderflowException {
        if (this.lenient) {
            bytesToSkip = Math.min(bytesToSkip, this.readRemaining());
        }
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    public void uncheckedReadSkipOne() {
        ++this.readPosition;
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        --this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) throws BufferOverflowException {
        this.writeCheckOffset(this.writePosition, bytesToSkip);
        this.uncheckedWritePosition(this.writePosition + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) throws BufferOverflowException {
        if (limit < this.start()) {
            throw this.writeLimitTooSmall(limit);
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            throw this.writeLimitTooBig(limit, capacity);
        }
        this.writeLimit = limit;
        return this;
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooBig(long limit, long capacity) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d > capacity: %d", limit, capacity));
    }

    @NotNull
    private DecoratedBufferOverflowException writeLimitTooSmall(long limit) {
        return new DecoratedBufferOverflowException(String.format("writeLimit failed. Limit: %d < start: %d", limit, this.start()));
    }

    void performRelease() throws IllegalStateException {
        try {
            this.bytesStore.release();
        }
        finally {
            this.bytesStore = NoBytesStore.noBytesStore();
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readUnsignedByte(offset);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int readUnsignedByte(long offset) throws BufferUnderflowException {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        try {
            int unsignedByte = this.bytesStore.readUnsignedByte(this.readPosition);
            ++this.readPosition;
            return unsignedByte;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public byte readByte() {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferUnderflowException e) {
            return 0;
        }
    }

    @Override
    public int peekUnsignedByte() {
        return this.readPosition >= this.writePosition ? -1 : this.bytesStore.peekUnsignedByte(this.readPosition);
    }

    @Override
    public short readShort() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(2L);
            return this.bytesStore.readShort(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public int readInt() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public long readLong() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    @Override
    public float readFloat() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readFloat(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0f;
            }
            throw e;
        }
    }

    @Override
    public double readDouble() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readDouble(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0.0;
            }
            throw e;
        }
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(4L);
            return this.bytesStore.readVolatileInt(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException {
        try {
            long offset = this.readOffsetPositionMoved(8L);
            return this.bytesStore.readVolatileLong(offset);
        }
        catch (BufferUnderflowException e) {
            if (this.lenient) {
                return 0L;
            }
            throw e;
        }
    }

    protected long readOffsetPositionMoved(long adding) throws BufferUnderflowException {
        long offset = this.readPosition;
        this.readCheckOffset(this.readPosition, adding, false);
        this.readPosition += adding;
        assert (this.readPosition <= this.readLimit());
        return offset;
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public boolean tryReserve() {
        return this.refCount.tryReserve();
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(long offset, byte i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeShort(long offset, short i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeFloat(long offset, float d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, RandomDataInput bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        assert (this.writeCheckOffset0(offset, adding));
    }

    protected boolean writeCheckOffset0(long offset, long adding) throws BufferOverflowException {
        if (offset < this.start()) {
            throw new DecoratedBufferOverflowException(String.format("writeCheckOffset0 failed. Offset: %d < start: %d", offset, this.start()));
        }
        if (offset + adding > this.writeLimit()) {
            assert (offset + adding <= this.writeLimit()) : "cant add bytes past the limit : limit=" + this.writeLimit() + ",offset=" + offset + ",adding=" + adding;
            throw new DecoratedBufferOverflowException(String.format("writeCheckOffset0 failed. Offset: %d + adding %d> writeLimit: %d", offset, adding, this.writeLimit()));
        }
        return true;
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException {
        return offset >= this.readLimit() ? -1 : this.bytesStore.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readDouble(offset);
    }

    void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException {
        assert (this.readCheckOffset0(offset, adding, given));
    }

    private boolean readCheckOffset0(long offset, long adding, boolean given) throws BufferUnderflowException {
        long limit0;
        if (offset < this.start()) {
            throw new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d < start: %d", offset, this.start()));
        }
        long l = limit0 = given ? this.writeLimit() : this.readLimit();
        if (offset + adding > limit0) {
            throw new DecoratedBufferUnderflowException(String.format("readCheckOffset0 failed. Offset: %d + adding: %d > limit: %d (given: %s)", offset, adding, limit0, given));
        }
        return true;
    }

    void prewriteCheckOffset(long offset, long subtracting) throws BufferOverflowException {
        assert (this.prewriteCheckOffset0(offset, subtracting));
    }

    private boolean prewriteCheckOffset0(long offset, long subtracting) throws BufferOverflowException {
        if (offset - subtracting < this.start()) {
            throw new DecoratedBufferOverflowException(String.format("prewriteCheckOffset0 failed. Offset: %d - subtracting: %d < start: %d", offset, subtracting, this.start()));
        }
        long limit0 = this.readLimit();
        if (offset > limit0) {
            throw new DecoratedBufferOverflowException(String.format("prewriteCheckOffset0 failed. Offset: %d > readLimit: %d", offset, limit0));
        }
        return true;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(1L, 1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull byte[] bytes) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull BytesStore bytes) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(bytes.readRemaining());
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteByte(byte i8) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteInt(int i) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteShort(short i) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> prewriteLong(long l) throws BufferOverflowException {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, l);
        return this;
    }

    protected final long writeOffsetPositionMoved(long adding) throws BufferOverflowException {
        return this.writeOffsetPositionMoved(adding, adding);
    }

    protected long writeOffsetPositionMoved(long adding, long advance) throws BufferOverflowException {
        long oldPosition = this.writePosition;
        this.writeCheckOffset(this.writePosition, adding);
        this.uncheckedWritePosition(this.writePosition + advance);
        return oldPosition;
    }

    void uncheckedWritePosition(long writePosition) {
        this.writePosition = writePosition;
    }

    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException {
        this.prewriteCheckOffset(this.readPosition, subtracting);
        return this.readPosition -= subtracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeShort(short i16) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeInt(int i) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeIntAdv(int i, int advance) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(4L, advance);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLong(long i64) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLongAdv(long i64, int advance) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(8L, advance);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeFloat(float f) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDouble(double d) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeDoubleAndInt(double d, int i) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(12L);
        this.bytesStore.writeDouble(offset, d);
        this.bytesStore.writeInt(offset + 8L, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull byte[] bytes, int offset, int length) throws BufferOverflowException {
        if (length + offset > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + bytes.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSome(@NotNull ByteBuffer buffer) throws BufferOverflowException {
        int length = (int)Math.min((long)buffer.remaining(), this.writeRemaining());
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), length);
        this.uncheckedWritePosition(this.writePosition + (long)length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedInt(int i) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long i) throws BufferOverflowException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException {
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException, BufferOverflowException {
        return this.bytesStore.addressForWrite(offset);
    }

    public int hashCode() {
        return BytesStoreHash.hash32(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BytesStore)) {
            return false;
        }
        BytesStore b2 = (BytesStore)obj;
        long remaining = this.readRemaining();
        return b2.readRemaining() == remaining && this.equalsBytes(b2, remaining);
    }

    public boolean equalsBytes(@NotNull BytesStore b2, long remaining) {
        long i;
        for (i = 0L; i < remaining - 7L; i += 8L) {
            if (this.readLong(this.readPosition() + i) == b2.readLong(b2.readPosition() + i)) continue;
            return false;
        }
        while (i < remaining) {
            if (this.readByte(this.readPosition() + i) != b2.readByte(b2.readPosition() + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public void nativeRead(long address, long size) throws BufferUnderflowException {
        long position = this.readPosition();
        this.readSkip(size);
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, long size) throws BufferOverflowException {
        long position = this.writePosition();
        this.writeSkip(size);
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, long position, long size) throws BufferOverflowException {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @NotNull
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }

    @Override
    public void lenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public boolean lenient() {
        return this.lenient;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        return this.byteCheckSum(this.readPosition(), this.readLimit());
    }

    @Override
    public int byteCheckSum(long start, long end) {
        if (end < Integer.MAX_VALUE && this.isDirectMemory()) {
            return this.byteCheckSum((int)start, (int)end);
        }
        return Bytes.super.byteCheckSum(start, end);
    }

    public int byteCheckSum(int start, int end) {
        int sum = 0;
        for (int i = start; i < end; ++i) {
            sum += this.readByte(i);
        }
        return sum & 0xFF;
    }
}

