/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingOutputStream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.io.IORuntimeException;

public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    public S writePosition(long var1) throws BufferOverflowException;

    public S writeLimit(long var1) throws BufferOverflowException;

    public S writeSkip(long var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public OutputStream outputStream() {
        return new StreamingOutputStream(this);
    }

    @NotNull
    default public S writeStopBit(long x) throws BufferOverflowException, IORuntimeException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    default public S writeStopBit(double d) throws BufferOverflowException, IORuntimeException {
        BytesInternal.writeStopBit(this, d);
        return (S)this;
    }

    @NotNull
    default public S writeUtf8(CharSequence cs) throws BufferOverflowException, IORuntimeException {
        BytesInternal.writeUtf8(this, cs);
        return (S)this;
    }

    @Deprecated
    default public S writeUTF\u0394(CharSequence cs) throws BufferOverflowException, IORuntimeException {
        return this.writeUtf8(cs);
    }

    default public S write8bit(CharSequence cs) throws BufferOverflowException, IORuntimeException {
        if (cs == null) {
            return this.writeStopBit(-1L);
        }
        if (cs instanceof BytesStore) {
            return this.write8bit((BytesStore)cs);
        }
        return this.write8bit(cs, 0, cs.length());
    }

    default public S write8bit(CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException, IORuntimeException {
        this.writeStopBit(length);
        return this.write(s, start, length);
    }

    default public S write(CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return this.write((BytesStore)cs);
        }
        return this.write(cs, 0, cs.length());
    }

    default public S write(CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException, IORuntimeException {
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + start);
            this.appendUtf8(c);
        }
        return (S)this;
    }

    default public S write8bit(@NotNull String s) throws BufferOverflowException, IORuntimeException {
        this.write8bit(s, 0, s.length());
        return (S)this;
    }

    default public S write8bit(@NotNull BytesStore sdi) throws BufferOverflowException, IORuntimeException {
        long offset = sdi.readPosition();
        long readRemaining = sdi.readLimit() - offset;
        this.writeStopBit(readRemaining);
        this.write(sdi, offset, readRemaining);
        return (S)this;
    }

    @NotNull
    public S writeByte(byte var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public S writeUnsignedByte(int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    @NotNull
    public S writeShort(short var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public S writeUnsignedShort(int u16) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    @NotNull
    public S writeInt(int var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public S writeUnsignedInt(long i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    @NotNull
    public S writeLong(long var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    public S writeFloat(float var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    public S writeDouble(double var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public S write(@NotNull BytesStore bytes) throws BufferOverflowException, IORuntimeException {
        return this.write(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    @NotNull
    default public S write(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException, IORuntimeException {
        BytesInternal.write(bytes, offset, length, this);
        return (S)this;
    }

    @NotNull
    default public S write(@NotNull byte[] bytes) throws BufferOverflowException, IORuntimeException {
        return this.write(bytes, 0, bytes.length);
    }

    @NotNull
    public S write(byte[] var1, int var2, int var3) throws BufferOverflowException, IllegalArgumentException, IORuntimeException;

    @NotNull
    public S write(ByteBuffer var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    default public S writeBoolean(boolean flag) throws BufferOverflowException, IORuntimeException {
        return this.writeByte(flag ? (byte)89 : 0);
    }

    @NotNull
    public S writeOrderedInt(int var1) throws BufferOverflowException, IORuntimeException;

    @NotNull
    public S writeOrderedLong(long var1) throws BufferOverflowException, IORuntimeException;

    public void nativeWrite(long var1, long var3) throws BufferOverflowException, IORuntimeException;

    default public <E extends Enum<E>> void writeEnum(E e) throws BufferOverflowException, IORuntimeException {
        this.write8bit(e.name());
    }

    default public S appendUtf8(CharSequence cs) throws BufferOverflowException, IORuntimeException {
        return this.appendUtf8(cs, 0, cs.length());
    }

    default public S appendUtf8(int codepoint) throws BufferOverflowException, IORuntimeException {
        BytesInternal.appendUtf8Char(this, codepoint);
        return (S)this;
    }

    default public S appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        char c;
        int i;
        block3: {
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.writeByte((byte)c);
                    continue;
                }
                break block3;
            }
            return (S)this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return (S)this;
    }

    default public S appendUtf8(CharSequence cs, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        BytesInternal.appendUtf8(this, cs, offset, length);
        return (S)this;
    }

    default public void copyFrom(InputStream input) throws IOException, BufferOverflowException, IllegalArgumentException {
        BytesInternal.copy(input, this);
    }
}

