/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.OS;

public final class ZeroRandomDataInput
implements RandomDataInput {
    public static final RandomDataInput INSTANCE = new ZeroRandomDataInput();

    private ZeroRandomDataInput() {
    }

    @Override
    public byte readByte(long offset) {
        return 0;
    }

    @Override
    public short readShort(long offset) {
        return 0;
    }

    @Override
    public int readInt(long offset) {
        return 0;
    }

    @Override
    public long readLong(long offset) {
        return 0L;
    }

    @Override
    public float readFloat(long offset) {
        return 0.0f;
    }

    @Override
    public double readDouble(long offset) {
        return 0.0;
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        OS.memory().setMemory(address, size, (byte)0);
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public long address() throws UnsupportedOperationException {
        return 0L;
    }

    @Override
    public Bytes bytesForRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes bytesForWrite() {
        throw new UnsupportedOperationException();
    }
}

