/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeAccess;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.ZeroedBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;

public class NativeBytes<Underlying>
extends ZeroedBytes<Underlying> {
    NativeBytes(BytesStore store) {
        super(store, UnderflowMode.PADDED);
    }

    public static NativeBytes<Void> nativeBytes() {
        return new NativeBytes<Void>(NoBytesStore.noBytesStore());
    }

    public static NativeBytes<Void> nativeBytes(long initialCapacity) {
        return new NativeBytes<Void>(NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity));
    }

    @Override
    public long capacity() {
        return 0x10000000000L;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) {
        if (!this.bytesStore.inStore(offset + adding)) {
            this.checkResize(offset + adding);
        }
    }

    @Override
    public void ensureCapacity(long size) {
        this.writeCheckOffset(size, 0L);
    }

    private void checkResize(long endOfBuffer) {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) {
        if (endOfBuffer < 0L) {
            throw new IllegalArgumentException();
        }
        long ps = OS.pageSize();
        long size = Math.max(endOfBuffer, this.bytesStore.capacity() * 3L / 2L) + ps & (ps - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytesStore<Object> store = this.bytesStore.underlyingObject() instanceof ByteBuffer ? NativeBytesStore.elasticByteBuffer(Maths.toInt32((long)size)) : NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        this.bytesStore.copyTo(store);
        this.bytesStore.release();
        this.bytesStore = store;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public Bytes<Underlying> write(Bytes bytes, long offset, long length) {
        if (bytes instanceof NativeBytes) {
            long len = Math.min(this.remaining(), Math.min(bytes.remaining(), length));
            this.writeCheckOffset(this.position(), len);
            NativeAccess.U.copyMemory(bytes.address() + offset, this.address() + this.position(), len);
            this.skip(len);
            return this;
        }
        return super.write(bytes, offset, length);
    }

    @Override
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) {
        if (bytes instanceof NativeBytesStore) {
            this.writeCheckOffset(this.position(), length);
            NativeAccess.U.copyMemory(bytes.address() + offset, this.address() + this.position(), length);
            this.skip(length);
            return this;
        }
        return super.write(bytes, offset, length);
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(Bytes bytes) {
        long remaining = bytes.remaining();
        NativeBytes<Void> bytes2 = NativeBytes.nativeBytes(remaining);
        bytes2.write(bytes, 0L, remaining);
        bytes2.flip();
        return bytes2;
    }
}

