/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ExpectedBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.VanillaBytes;
import org.jetbrains.annotations.NotNull;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
StreamingDataInput<Bytes<Underlying>, Access<Underlying>, Underlying>,
StreamingDataOutput<Bytes<Underlying>, Access<Underlying>, Underlying>,
ByteStringParser<Bytes<Underlying>, Access<Underlying>, Underlying>,
ByteStringAppender<Bytes<Underlying>, Access<Underlying>, Underlying>,
CharSequence {
    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer().bytes();
    }

    public static Bytes<ByteBuffer> wrap(ByteBuffer byteBuffer) {
        return BytesStore.wrap(byteBuffer).bytes(UnderflowMode.BOUNDED);
    }

    public static Bytes<byte[]> expect(String text) {
        return Bytes.expect(Bytes.wrap(text.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public static <B extends BytesStore<B, Underlying>, Underlying> Bytes<Underlying> expect(BytesStore<B, Underlying> bytesStore) {
        return new VanillaBytes(new ExpectedBytesStore<B, Underlying>(bytesStore));
    }

    public static Bytes<byte[]> wrap(byte[] byteArray) {
        return BytesStore.wrap(byteArray).bytes(UnderflowMode.BOUNDED);
    }

    public static Bytes<byte[]> from(String text) {
        return Bytes.wrap(text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy();

    default public String toHexString() {
        return BytesUtil.toHexString(this, this.position(), this.realCapacity() - this.position());
    }

    default public String toHexString(long maxLength) {
        if (this.realCapacity() - this.position() < maxLength) {
            return this.toHexString();
        }
        return BytesUtil.toHexString(this, this.position(), maxLength) + ".... truncated";
    }

    @Override
    public long limit();

    @Override
    public Bytes<Underlying> position(long var1);

    @Override
    public long position();

    @Override
    public Bytes<Underlying> limit(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull Bytes buffer) {
        if (buffer.remaining() == 0L) {
            return "";
        }
        long position = buffer.position();
        long limit = buffer.limit();
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            return "";
        }
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0) {
                builder.append((char)buffer.get());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull Bytes buffer, long position, long len) {
        long pos = buffer.position();
        long limit = buffer.readLimit();
        buffer.position(position);
        buffer.limit(position + len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.remaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(pos);
        }
    }

    @Deprecated
    public Bytes mark();

    @Deprecated
    public Bytes reset() throws InvalidMarkException;

    @Override
    default public int length() {
        if (this.position() == 0L) {
            return (int)Math.min(this.limit(), Integer.MAX_VALUE);
        }
        if (this.position() == this.limit() || this.limit() == this.capacity()) {
            return (int)Math.min(this.position(), Integer.MAX_VALUE);
        }
        throw new IllegalStateException();
    }

    @Override
    default public char charAt(int offset) {
        return (char)this.readUnsignedByte(offset);
    }

    @Override
    default public String subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) {
        if (size > this.capacity()) {
            throw new UnsupportedOperationException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    default public Bytes<Underlying> bytes() {
        boolean isClear = this.start() == this.position() && this.limit() == this.capacity();
        return isClear ? BytesStore.super.bytes() : new SubBytes(this, this.position(), this.limit() + this.start());
    }

    @Override
    public Access<Underlying> access();
}

