/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.util.function.ToLongFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.algo.OptimisedBytesHash;
import net.openhft.chronicle.bytes.algo.VanillaBytesStoreHash;

public interface BytesStoreHash<B extends BytesStore>
extends ToLongFunction<B> {
    public static long hash(VanillaBytes b) {
        return OptimisedBytesHash.INSTANCE.applyAsLong(b);
    }

    public static long hash(BytesStore b) {
        return b instanceof NativeBytes ? OptimisedBytesHash.INSTANCE.applyAsLong((NativeBytes)b) : VanillaBytesStoreHash.INSTANCE.applyAsLong(b);
    }
}

