/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i;
        String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i = 1; i < 21; ++i) {
            charToString[i] = Character.toString((char)(i + 9351));
        }
        for (i = 32; i < 256; ++i) {
            charToString[i] = Character.toString((char)i);
        }
        for (i = 21; i < 32; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        for (i = 128; i < 160; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        return charToString;
    }

    @ForceInline
    default public boolean readBoolean(long offset) {
        return this.readByte(offset) != 0;
    }

    public byte readByte(long var1);

    @ForceInline
    default public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    public short readShort(long var1);

    @ForceInline
    default public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    public int readInt(long var1);

    @ForceInline
    default public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1);

    public float readFloat(long var1);

    public double readDouble(long var1);

    default public String printable(long offset) {
        return charToString[this.readUnsignedByte(offset)];
    }

    default public int readVolatileInt(long offset) {
        OS.memory().loadFence();
        return this.readInt(offset);
    }

    default public long readVolatileLong(long offset) {
        OS.memory().loadFence();
        return this.readLong(offset);
    }

    default public long parseLong(long offset) {
        return BytesUtil.parseLong(this, offset);
    }

    public void nativeRead(long var1, long var3, long var5);

    @Deprecated
    default public boolean bytesEqual(long offset, @NotNull RandomDataInput second, long secondOffset, long len) {
        long i = 0L;
        while (len - i >= 8L) {
            if (this.readLong(offset + i) != second.readLong(secondOffset + i)) {
                return false;
            }
            i += 8L;
        }
        if (len - i >= 4L) {
            if (this.readInt(offset + i) != second.readInt(secondOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (len - i >= 2L) {
            if (this.readShort(offset + i) != second.readShort(secondOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || this.readByte(offset + i) == second.readByte(secondOffset + i);
    }

    default public void copyTo(@NotNull byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.readByte(this.start() + (long)i);
        }
    }

    default public long readIncompleteLong(long offset) {
        long left = this.readRemaining() - offset;
        if (left >= 8L) {
            return this.readLong(offset);
        }
        if (left == 4L) {
            return this.readInt(offset);
        }
        long l = 0L;
        int remaining = (int)left;
        for (int i = 0; i < remaining; ++i) {
            l |= (long)this.readUnsignedByte(offset + (long)i) << i * 8;
        }
        return l;
    }

    public long realCapacity();
}

