/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;

public class NativeBytes<Underlying>
extends VanillaBytes<Underlying> {
    NativeBytes(BytesStore store) {
        super(store, 0L, Long.MAX_VALUE);
    }

    public static NativeBytes<Void> nativeBytes() {
        return new NativeBytes<Void>(NoBytesStore.noBytesStore());
    }

    public static NativeBytes<Void> nativeBytes(long initialCapacity) {
        return new NativeBytes<Void>(NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity));
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(Bytes bytes) {
        long remaining = bytes.readRemaining();
        NativeBytes<Void> bytes2 = Bytes.allocateElasticDirect(remaining);
        bytes2.write(bytes, 0L, remaining);
        return bytes2;
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) {
        if (!this.bytesStore.inside(offset + adding)) {
            this.checkResize(offset + adding);
        }
    }

    @Override
    public void ensureCapacity(long size) {
        this.writeCheckOffset(size, 0L);
    }

    private void checkResize(long endOfBuffer) {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public int readVolatileInt(long offset) {
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) {
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) {
        if (endOfBuffer < 0L) {
            throw new IllegalArgumentException();
        }
        long ps = OS.pageSize();
        long size = Math.max(endOfBuffer, this.bytesStore.capacity() * 3L / 2L) + ps & (ps - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytesStore<Object> store = this.bytesStore.underlyingObject() instanceof ByteBuffer ? NativeBytesStore.elasticByteBuffer(Maths.toInt32((long)size)) : NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        this.bytesStore.copyTo(store);
        this.bytesStore.release();
        this.bytesStore = store;
    }

    @Override
    public long readIncompleteLong(long offset) {
        return this.bytesStore.readIncompleteLong(offset);
    }

    @Override
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) {
        long position = this.writePosition();
        this.ensureCapacity(position + (long)length);
        super.write(bytes, offset, length);
        return this;
    }

    @Override
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) {
        long position = this.writePosition();
        this.ensureCapacity(position + length);
        super.write(bytes, offset, length);
        return this;
    }
}

