/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;

public class UncheckedBytes<Underlying>
extends AbstractBytes<Underlying> {
    public UncheckedBytes(Bytes underlyingBytes) {
        super(underlyingBytes.bytesStore(), underlyingBytes.writePosition(), underlyingBytes.writeLimit());
        this.readPosition(underlyingBytes.readPosition());
    }

    @Override
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    void writeCheckOffset(long offset, long adding) {
    }

    @Override
    void readCheckOffset(long offset, long adding) {
    }

    @Override
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    public Bytes<Underlying> readLimit(long limit) {
        this.writePosition = limit;
        return this;
    }

    @Override
    public Bytes<Underlying> writePosition(long position) {
        this.writePosition = position;
        return this;
    }

    @Override
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    @Override
    protected long writeOffsetPositionMoved(long adding) {
        long oldPosition = this.writePosition;
        this.writePosition += adding;
        return oldPosition;
    }

    @Override
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.underlyingObject() == null && length >= 64L) {
            this.rawCopy(bytes, offset, length);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    public void rawCopy(BytesStore bytes, long offset, long length) {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
            this.writeSkip(len);
        }
    }
}

