/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesStoreBytes;
import net.openhft.chronicle.bytes.UnderflowMode;

public class ZeroedBytes<Underlying>
extends BytesStoreBytes<Underlying> {
    private final UnderflowMode underflowMode;

    public ZeroedBytes(BytesStore store, UnderflowMode underflowMode) {
        super(store);
        this.underflowMode = underflowMode;
    }

    @Override
    public byte readByte() {
        return this.positionOk(1) ? super.readByte() : (byte)0;
    }

    private boolean positionOk(int needs) {
        return this.underflowMode.isRemainingOk(this.remaining(), needs);
    }

    @Override
    public short readShort() {
        return this.positionOk(2) ? super.readShort() : (short)0;
    }

    @Override
    public int readInt() {
        return this.positionOk(4) ? super.readInt() : 0;
    }

    @Override
    public long readLong() {
        return this.positionOk(8) ? super.readLong() : 0L;
    }

    @Override
    public float readFloat() {
        return this.positionOk(4) ? super.readFloat() : 0.0f;
    }

    @Override
    public double readDouble() {
        return this.positionOk(8) ? super.readDouble() : 0.0;
    }
}

