/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.ZeroedBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;

public class NativeBytes<Underlying>
extends ZeroedBytes<Underlying> {
    NativeBytes(BytesStore store) {
        super(store, UnderflowMode.PADDED);
    }

    public static NativeBytes nativeBytes() {
        return new NativeBytes(NoBytesStore.noBytesStore());
    }

    public static NativeBytes nativeBytes(long initialCapacity) {
        return new NativeBytes(NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity));
    }

    @Override
    protected long writeCheckOffset(long offset, long adding) {
        if (!this.bytesStore.inStore(offset)) {
            this.checkResize(offset);
        }
        return offset;
    }

    private void checkResize(long offset) {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(offset);
    }

    private void resize(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        long ps = OS.pageSize();
        long size = Math.max(offset, this.bytesStore.capacity() * 3L / 2L) + ps & (ps - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytesStore<Object> store = this.bytesStore.underlyingObject() instanceof ByteBuffer ? NativeBytesStore.elasticByteBuffer(Maths.toInt32((long)size)) : NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        this.bytesStore.copyTo(store);
        this.bytesStore.release();
        this.bytesStore = store;
    }

    @Override
    public long capacity() {
        return 0x10000000000L;
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    public void ensureCapacity(long size) {
        this.writeCheckOffset(size, 0L);
    }

    @Override
    public boolean isNative() {
        return true;
    }
}

