/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.analytics.internal.VanillaAnalyticsBuilder;
import org.jetbrains.annotations.NotNull;

public interface Analytics {
    default public void sendEvent(@NotNull String name) {
        this.sendEvent(name, Collections.emptyMap());
    }

    public void sendEvent(@NotNull String var1, @NotNull Map<String, String> var2);

    @NotNull
    public static Builder builder(@NotNull String measurementId, @NotNull String apiSecret) {
        return new VanillaAnalyticsBuilder(measurementId, apiSecret);
    }

    public static interface Builder {
        @NotNull
        public Builder putUserProperty(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder putEventParameter(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder withFrequencyLimit(long var1, @NotNull TimeUnit var3);

        @NotNull
        public Builder withErrorLogger(@NotNull Consumer<String> var1);

        @NotNull
        public Builder withDebugLogger(@NotNull Consumer<String> var1);

        @NotNull
        public Builder withClientIdFileName(@NotNull String var1);

        @NotNull
        public Builder withUrl(@NotNull String var1);

        @NotNull
        public Builder withReportDespiteJUnit();

        @NotNull
        public Analytics build();
    }
}

