/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import java.lang.management.ManagementFactory;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.impl.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NullAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;

    @Override
    public BitSet getAffinity() {
        return null;
    }

    @Override
    public void setAffinity(BitSet affinity) {
        LOGGER.trace("unable to set mask to {} as the JNIa nd JNA libraries and not loaded", (Object)Utilities.toHexString(affinity));
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

    @Override
    public int getThreadId() {
        throw new UnsupportedOperationException();
    }

    static {
        LOGGER = LoggerFactory.getLogger(NullAffinity.class);
    }
}

