/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.Platform;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.impl.LinuxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LinuxJNAAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;
    public static final boolean LOADED;
    private static final int PROCESS_ID;
    private static final int SYS_gettid;
    private static final Object[] NO_ARGS;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();

    @Override
    public BitSet getAffinity() {
        LinuxHelper.cpu_set_t cpuset = LinuxHelper.sched_getaffinity();
        boolean collect = false;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        ByteBuffer buff = null;
        buff = Platform.is64Bit() ? ByteBuffer.allocate(8) : ByteBuffer.allocate(4);
        for (int i = cpuset.__bits.length - 1; i >= 0; --i) {
            if (!collect && cpuset.__bits[i].longValue() != 0L) {
                collect = true;
            }
            if (!collect) continue;
            if (Platform.is64Bit()) {
                buff.putLong(cpuset.__bits[i].longValue());
            } else {
                buff.putInt((int)cpuset.__bits[i].longValue());
            }
            byte[] arr = buff.array();
            for (int j = 0; j < arr.length; ++j) {
                bytes.add(arr[j]);
            }
        }
        if (!bytes.isEmpty()) {
            byte[] data = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                data[data.length - i - 1] = (Byte)bytes.get(i);
            }
            return BitSet.valueOf(data);
        }
        return new BitSet();
    }

    @Override
    public void setAffinity(BitSet affinity) {
        LinuxHelper.sched_setaffinity(affinity);
    }

    @Override
    public int getCpu() {
        return LinuxHelper.sched_getcpu();
    }

    @Override
    public int getProcessId() {
        return PROCESS_ID;
    }

    @Override
    public int getThreadId() {
        Integer tid = this.THREAD_ID.get();
        if (tid == null) {
            tid = LinuxHelper.syscall(SYS_gettid, NO_ARGS);
            this.THREAD_ID.set(tid);
        }
        return tid;
    }

    static {
        LOGGER = LoggerFactory.getLogger(LinuxJNAAffinity.class);
        int pid = -1;
        try {
            pid = LinuxHelper.getpid();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        PROCESS_ID = pid;
        SYS_gettid = Platform.is64Bit() ? 186 : 224;
        NO_ARGS = new Object[0];
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library {}", (Throwable)e);
        }
        LOADED = loaded;
    }
}

