/*
 * Decompiled with CFR 0.152.
 */
package net.java.hulp.i18n;

import java.util.logging.Level;
import net.java.hulp.i18n.LocalizedString;

public final class Logger {
    private final java.util.logging.Logger mDelegate;

    private Logger(java.util.logging.Logger delegate) {
        this.mDelegate = delegate;
    }

    public static Logger getLogger(String name) {
        return new Logger(java.util.logging.Logger.getLogger(name));
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public final void fine(Object message) {
        this.mDelegate.log(Level.FINE, message == null ? null : message.toString());
    }

    public final void fine(Object message, Throwable t) {
        this.mDelegate.log(Level.FINE, message == null ? null : message.toString(), t);
    }

    public final void finer(Object message) {
        this.mDelegate.log(Level.FINER, message == null ? null : message.toString());
    }

    public final void finer(Object message, Throwable t) {
        this.mDelegate.log(Level.FINER, message == null ? null : message.toString(), t);
    }

    public final void finest(Object message) {
        this.mDelegate.log(Level.FINEST, message == null ? null : message.toString());
    }

    public final void finest(Object message, Throwable t) {
        this.mDelegate.log(Level.FINEST, message == null ? null : message.toString(), t);
    }

    public final void severe(LocalizedString message) {
        this.mDelegate.log(Level.SEVERE, message == null ? null : message.toString());
    }

    public final void severe(LocalizedString message, Throwable t) {
        this.mDelegate.log(Level.SEVERE, message == null ? null : message.toString(), t);
    }

    public final void errorNoloc(String message, Throwable t) {
        this.mDelegate.log(Level.SEVERE, message == null ? null : message.toString(), t);
    }

    public final void info(LocalizedString message) {
        this.mDelegate.log(Level.INFO, message == null ? null : message.toString());
    }

    public final void infoNoloc(String message) {
        this.mDelegate.log(Level.INFO, message == null ? null : message.toString());
    }

    public final void infoNoloc(String message, Throwable t) {
        this.mDelegate.log(Level.INFO, message == null ? null : message.toString(), t);
    }

    public final void info(LocalizedString message, Throwable t) {
        this.mDelegate.log(Level.INFO, message == null ? null : message.toString(), t);
    }

    public final boolean isFine() {
        return this.mDelegate.isLoggable(Level.FINE);
    }

    public final void warn(LocalizedString message) {
        this.mDelegate.log(Level.WARNING, message == null ? null : message.toString());
    }

    public final void warn(LocalizedString message, Throwable t) {
        this.mDelegate.log(Level.WARNING, message == null ? null : message.toString(), t);
    }

    public final void warnNoloc(String message) {
        this.mDelegate.log(Level.WARNING, message == null ? null : message.toString());
    }

    public final String getName() {
        return this.mDelegate.getName();
    }

    public final Level getLevel() {
        return this.mDelegate.getLevel();
    }

    public final boolean isLoggable(Level level) {
        return this.mDelegate.isLoggable(level);
    }

    public final boolean isInfo() {
        return this.mDelegate.isLoggable(Level.INFO);
    }

    public final void setLevel(Level level) {
        this.mDelegate.setLevel(level);
    }
}

