/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.WsdlException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class DOMUtilities {
    DOMUtilities() {
    }

    public static QName resolveNamespace(Attr attr, String documentURI) throws WsdlException {
        QName result = null;
        if (attr != null) {
            Element element = attr.getOwnerElement();
            String value = attr.getValue();
            try {
                result = DOMUtilities.resolveNamespace(value, element, documentURI);
            }
            catch (WsdlException ex) {
                throw new WsdlException("Illegal qualified name {0} in value of attribute {2} in document {1}", new Object[]{value, documentURI, attr.getName()});
            }
        }
        return result;
    }

    public static QName resolveNamespace(String value, Element element, String documentURI) throws WsdlException {
        QName result = null;
        if (value != null) {
            String targetNsDecl;
            int valueLength = value.length();
            int colonIndex = value.indexOf(58);
            if (colonIndex > 0 && colonIndex < valueLength - 1) {
                targetNsDecl = "xmlns:" + value.substring(0, colonIndex);
            } else if (colonIndex < 0 && valueLength > 0) {
                targetNsDecl = "xmlns";
            } else {
                throw new WsdlException("Illegal qualified name {0} in element {2} in document {1}", new Object[]{value, documentURI, element.getNodeName()});
            }
            Attr nsDeclAttr = DOMUtilities.findAttribute(element, targetNsDecl);
            if (nsDeclAttr != null) {
                result = new QName(nsDeclAttr.getValue(), value.substring(colonIndex + 1));
            }
        }
        return result;
    }

    private static Attr findAttribute(Element element, String targetName) {
        Node parent;
        Attr result = null;
        if (element != null && (result = element.getAttributeNode(targetName)) == null && (parent = element.getParentNode()) != null && parent.getNodeType() == 1) {
            result = DOMUtilities.findAttribute((Element)parent, targetName);
        }
        return result;
    }

    public static Document getDocument(String documentBaseURI, InputSource inputSource) throws WsdlException {
        Document result;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(inputSource);
        }
        catch (Exception ex) {
            throw new WsdlException("Problem parsing '{0}.\n\tReason = {0}\n", new Object[]{documentBaseURI, ex.getMessage()});
        }
        return result;
    }
}

