/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging.stats;

public class METimestamps {
    private static final int STAMP_COUNT = 12;
    private int mIndex;
    private long[] mStamps = new long[13];
    private byte[] mTags = new byte[13];
    public long mConsumerTime;
    public long mProviderTime;
    public long mNMRTime;
    public long mConsumerChannelTime;
    public long mProviderChannelTime;
    public long mResponseTime;
    public long mStatusTime;
    private static String[] mStrings = new String[]{"???", "Csend", "Pqueue", "Paccept", "Psend", "Cqueue", "Caccept"};
    public static final byte TAG_CSEND = 1;
    public static final byte TAG_PQUEUE = 2;
    public static final byte TAG_PACCEPT = 3;
    public static final byte TAG_PSEND = 4;
    public static final byte TAG_CQUEUE = 5;
    public static final byte TAG_CACCEPT = 6;

    public void capture(byte tag) {
        if (this.mIndex < 12) {
            this.mStamps[this.mIndex] = System.nanoTime();
            this.mTags[this.mIndex] = tag;
            ++this.mIndex;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.mStamps != null) {
            sb.append("Timestamps(" + this.mIndex + "): ");
            for (int i = 0; i < this.mIndex; ++i) {
                sb.append(mStrings[this.mTags[i] <= 6 ? this.mTags[i] : 0]);
                sb.append("(");
                sb.append(i == 0 ? this.mStamps[0] : this.mStamps[i] - this.mStamps[0]);
                sb.append(")");
            }
        } else {
            sb.append("Timing: Consumer: " + this.mConsumerTime);
            sb.append(" +Channel: " + this.mConsumerChannelTime);
            sb.append(" Provider: " + this.mProviderTime);
            sb.append(" +Channel: " + this.mProviderChannelTime);
            sb.append(" NMR: " + this.mNMRTime);
            sb.append(" Response: " + this.mResponseTime);
            sb.append(" Status: " + this.mStatusTime);
        }
        return sb.toString();
    }

    public void compute() {
        int statusStart = 0;
        boolean response = false;
        for (int i = 0; i < this.mIndex; ++i) {
            if (this.mTags[i] == 1 && this.mTags[i + 1] == 2 || this.mTags[i] == 4 && this.mTags[i + 1] == 5) {
                this.mNMRTime += this.mStamps[i + 1] - this.mStamps[i];
            } else if (this.mTags[i] == 2 && this.mTags[i + 1] == 3) {
                this.mProviderChannelTime += this.mStamps[i + 1] - this.mStamps[i];
            } else if (this.mTags[i] == 3) {
                if (this.mTags[i + 1] == 4) {
                    this.mProviderTime += this.mStamps[i + 1] - this.mStamps[i];
                }
                if (statusStart != 0) {
                    this.mStatusTime = this.mStamps[i] - this.mStamps[statusStart];
                }
            } else if (this.mTags[i] == 6) {
                if (this.mTags[i + 1] == 1) {
                    this.mConsumerTime += this.mStamps[i + 1] - this.mStamps[i];
                }
                if (!response) {
                    this.mResponseTime += this.mStamps[i] - this.mStamps[0];
                    response = true;
                }
            } else if (this.mTags[i] == 5 && this.mTags[i + 1] == 6) {
                this.mConsumerChannelTime += this.mStamps[i + 1] - this.mStamps[i];
            }
            if (this.mTags[i] != 4) continue;
            statusStart = i;
        }
        this.mTags = null;
        this.mStamps = null;
    }
}

