/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.ExchangePattern;
import com.sun.jbi.messaging.InOnlyImpl;
import com.sun.jbi.messaging.InOptionalOutImpl;
import com.sun.jbi.messaging.InOutImpl;
import com.sun.jbi.messaging.MessageExchangeImpl;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.RobustInOnlyImpl;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.messaging.util.WSDLHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class ExchangeFactory
implements MessageExchangeFactory {
    private MessageService mMsgSvc;
    private QName mInterface;
    private QName mService;
    private ServiceEndpoint mEndpoint;
    private EndpointRegistry mRegistry;

    ExchangeFactory(MessageService msgSvc) {
        this.mMsgSvc = msgSvc;
        this.mRegistry = EndpointRegistry.getInstance();
    }

    static ExchangeFactory newInterfaceFactory(MessageService msgSvc, QName interfaceName) {
        ExchangeFactory ef = new ExchangeFactory(msgSvc);
        ef.setInterface(interfaceName);
        return ef;
    }

    static ExchangeFactory newServiceFactory(MessageService msgSvc, QName serviceName) {
        ExchangeFactory ef = new ExchangeFactory(msgSvc);
        ef.setService(serviceName);
        return ef;
    }

    static ExchangeFactory newEndpointFactory(MessageService msgSvc, ServiceEndpoint endpoint) {
        ExchangeFactory ef = new ExchangeFactory(msgSvc);
        ef.setEndpoint(endpoint);
        return ef;
    }

    public MessageExchange createExchange(URI pattern) throws MessagingException {
        MessageExchangeProxy proxy;
        switch (ExchangePattern.valueOf(pattern)) {
            case IN_ONLY: {
                proxy = new InOnlyImpl();
                break;
            }
            case IN_OUT: {
                proxy = new InOutImpl();
                break;
            }
            case IN_OPTIONAL_OUT: {
                proxy = new InOptionalOutImpl();
                break;
            }
            case ROBUST_IN_ONLY: {
                proxy = new RobustInOnlyImpl();
                break;
            }
            default: {
                throw new MessagingException(Translator.translate("INVALID_MEP_URI", new Object[]{pattern}));
            }
        }
        MessageExchangeImpl impl = new MessageExchangeImpl(proxy, this.mMsgSvc);
        proxy.setInterfaceName(this.mInterface);
        proxy.setService(this.mService);
        proxy.setEndpoint(this.mEndpoint);
        return proxy;
    }

    public MessageExchange createExchange(QName serviceName, QName operationName) throws MessagingException {
        HashMap operations = null;
        RegisteredEndpoint[] endpoints = this.mRegistry.getInternalEndpointsForService(serviceName, true);
        if (endpoints.length == 0) {
            throw new MessagingException(Translator.translate("CANT_FIND_ENDPOINT_FOR_SERVICE", new Object[]{serviceName}));
        }
        Document desc = this.mMsgSvc.queryDescriptor(endpoints[0]);
        if (desc != null) {
            operations = WSDLHelper.getOperationsForService(desc, serviceName);
        }
        if (operations == null) {
            throw new MessagingException(Translator.translate("ENDPOINT_NO_DESCRIPTOR", new Object[]{endpoints[0].getEndpointName()}));
        }
        if (!operations.containsKey(operationName.toString())) {
            throw new MessagingException(Translator.translate("NONEXISTENT_OPERATION", new Object[]{operationName.toString()}));
        }
        URI opURI = ExchangeFactory.createURI((String)operations.get(operationName.toString()));
        MessageExchange exchange = this.createExchange(opURI);
        exchange.setService(serviceName);
        exchange.setOperation(operationName);
        return exchange;
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        return (InOnly)this.createExchange(ExchangePattern.IN_ONLY.getURI());
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        return (InOptionalOut)this.createExchange(ExchangePattern.IN_OPTIONAL_OUT.getURI());
    }

    public InOut createInOutExchange() throws MessagingException {
        return (InOut)this.createExchange(ExchangePattern.IN_OUT.getURI());
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        return (RobustInOnly)this.createExchange(ExchangePattern.ROBUST_IN_ONLY.getURI());
    }

    private void setInterface(QName interfaceName) {
        this.mInterface = interfaceName;
    }

    private void setService(QName serviceName) {
        this.mService = serviceName;
    }

    private void setEndpoint(ServiceEndpoint endpoint) {
        this.mEndpoint = endpoint;
    }

    private static URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException uriEx) {
            throw new IllegalArgumentException();
        }
    }
}

