/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.internal.support.JarURLHelper;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.ManagementMessageHolder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jbi.management.DeploymentException;

public class ServiceAssembly {
    private URL mSaURL;
    private ZipFile mZipFile = null;
    private BuildManagementMessageImpl mMImpl = null;
    private StringTranslator mTranslator = null;
    private Logger mLogger = null;

    public ServiceAssembly(URL saURL, StringTranslator translator, Logger logger) throws IOException, DeploymentException {
        this.mLogger = logger;
        this.mTranslator = translator;
        this.mSaURL = JarURLHelper.convertToJarURL(saURL, this.mTranslator);
        this.mMImpl = new BuildManagementMessageImpl();
        this.mZipFile = JarURLHelper.getZipFileFromURL(this.mSaURL, this.mTranslator);
    }

    public ZipFile getZipFile() {
        return this.mZipFile;
    }

    public URL getZipURL() {
        return this.mSaURL;
    }

    public InputStream getJbiXml() throws DeploymentException, IOException {
        InputStream is = null;
        boolean hasJbiXML = false;
        Enumeration<? extends ZipEntry> e = this.mZipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (!ze.getName().equalsIgnoreCase("META-INF/jbi.xml")) continue;
            is = this.mZipFile.getInputStream(ze);
            hasJbiXML = true;
        }
        if (!hasJbiXML) {
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
            mmHolder.setTaskName("readjbiXmlFromSAZip");
            mmHolder.setExceptionObject(new Exception("Cannot find deployment descriptor"));
            mmHolder.setLocToken(1, "JBI_XML_NOT_FOUND_IN_SA_JAR");
            String jbiTaskStr = this.mMImpl.buildCompleteExceptionMessage(mmHolder);
            throw new DeploymentException(jbiTaskStr);
        }
        return is;
    }

    public void done() {
        try {
            if (this.mZipFile != null) {
                this.mZipFile.close();
            }
        }
        catch (IOException ioex) {
            this.mLogger.log(Level.FINEST, "Could not close the Service Assembly zip file {0}", this.getZipURL().toString());
        }
    }
}

