/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.registry.xml.RegistryImpl;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.system.ManagementContext;
import java.util.List;
import java.util.logging.Logger;

public class RegistryUtil {
    private static final String DOMAIN = "domain";
    private RegistryImpl mRegistry;
    private ManagementContext mMgtCtx;
    private StringTranslator mTranslator;
    private Logger mLog;

    public RegistryUtil(ManagementContext mgtCtx, RegistryImpl registry) {
        this.mRegistry = registry;
        this.mMgtCtx = mgtCtx;
        this.mLog = mgtCtx.getLogger();
        this.mTranslator = mgtCtx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
    }

    public synchronized void syncWithRepository() throws Exception {
        String readOnly = this.mRegistry.getProperty("com.sun.jbi.registry.readonly");
        if (!Boolean.parseBoolean(readOnly)) {
            this.syncEntity(ArchiveType.SERVICE_ASSEMBLY);
            this.syncEntity(ArchiveType.COMPONENT);
            this.cleanOrphanedServiceAssemblies();
            this.syncEntity(ArchiveType.SHARED_LIBRARY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanEntity(ArchiveType type, String name, boolean isInRegistry, boolean isInRepository) throws RegistryException, RepositoryException {
        String missingFromReg = "JBI_ADMIN_SHARED_LIBRARY_MISSING_IN_REGISTRY";
        String removingFromReg = "JBI_ADMIN_REMOVING_SHARED_LIBRARY_FROM_REGISTRY";
        String missingFromRepos = "JBI_ADMIN_SHARED_LIBRARY_MISSING_IN_REPOSITORY";
        String removingFromRepos = "JBI_ADMIN_REMOVING_SHARED_LIBRARY_FROM_REPOSITORY";
        if (type.equals(ArchiveType.COMPONENT)) {
            missingFromReg = "JBI_ADMIN_COMPONENT_MISSING_IN_REGISTRY";
            removingFromReg = "JBI_ADMIN_REMOVING_COMPONENT_FROM_REGISTRY";
            missingFromRepos = "JBI_ADMIN_COMPONENT_MISSING_IN_REPOSITORY";
            removingFromRepos = "JBI_ADMIN_REMOVING_COMPONENT_FROM_REPOSITORY";
        } else if (type.equals(ArchiveType.SERVICE_ASSEMBLY)) {
            missingFromReg = "JBI_ADMIN_SERVICE_ASSEMBLY_MISSING_IN_REGISTRY";
            removingFromReg = "JBI_ADMIN_REMOVING_SERVICE_ASSEMBLY_FROM_REGISTRY";
            missingFromRepos = "JBI_ADMIN_SERVICE_ASSEMBLY_MISSING_IN_REPOSITORY";
            removingFromRepos = "JBI_ADMIN_REMOVING_SERVICE_ASSEMBLY_FROM_REPOSITORY";
        }
        RegistryImpl registryImpl = this.mRegistry;
        synchronized (registryImpl) {
            if (!isInRegistry && isInRepository) {
                this.mLog.warning(this.mTranslator.getString(missingFromReg, (Object)name));
                this.mLog.info(this.mTranslator.getString(removingFromRepos, (Object)name));
                this.mMgtCtx.getRepository().removeArchive(type, name);
            }
            if (isInRegistry && !isInRepository) {
                this.mLog.warning(this.mTranslator.getString(missingFromRepos, (Object)name));
                this.mLog.info(this.mTranslator.getString(removingFromReg, (Object)name));
                Updater updater = this.mRegistry.getUpdater();
                List<String> serversAndClusters = this.mRegistry.getGenericQuery().getServers();
                serversAndClusters.addAll(this.mRegistry.getGenericQuery().getClusters());
                if (type.equals(ArchiveType.SHARED_LIBRARY)) {
                    for (String sc : serversAndClusters) {
                        updater.removeSharedLibrary(sc, name);
                    }
                    updater.removeSharedLibrary(DOMAIN, name);
                } else if (type.equals(ArchiveType.COMPONENT)) {
                    for (String sc : serversAndClusters) {
                        updater.removeComponent(sc, name);
                    }
                    updater.removeComponent(DOMAIN, name);
                } else if (type.equals(ArchiveType.SERVICE_ASSEMBLY)) {
                    for (String sc : serversAndClusters) {
                        ComponentQuery compQuery = this.mRegistry.getComponentQuery(sc);
                        List comps = compQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
                        for (String comp : comps) {
                            ComponentInfo compInfo = compQuery.getComponentInfo(comp);
                            this.removeServiceAssemblyFromComponent(sc, compInfo, name);
                        }
                        updater.removeServiceAssembly(sc, name);
                    }
                    updater.removeServiceAssembly(DOMAIN, name);
                }
            }
        }
    }

    private void removeServiceAssemblyFromComponent(String target, ComponentInfo compInfo, String saName) throws RegistryException {
        List suInfos = compInfo.getServiceUnitList();
        Updater updater = this.mRegistry.getUpdater();
        for (ServiceUnitInfo suInfo : suInfos) {
            if (!saName.equals(suInfo.getServiceAssemblyName())) continue;
            updater.removeServiceUnitFromComponent(target, compInfo.getName(), suInfo.getName());
        }
    }

    private void syncEntity(ArchiveType type) throws Exception {
        List<String> registeredEntities = null;
        if (type.equals(ArchiveType.COMPONENT)) {
            registeredEntities = this.mRegistry.getGenericQuery().getRegisteredComponents();
        } else if (type.equals(ArchiveType.SERVICE_ASSEMBLY)) {
            registeredEntities = this.mRegistry.getGenericQuery().getRegisteredServiceAssemblies();
        } else if (type.equals(ArchiveType.SHARED_LIBRARY)) {
            registeredEntities = this.mRegistry.getGenericQuery().getRegisteredSharedLibraries();
        }
        List<String> repositoryEntities = this.mMgtCtx.getRepository().getArchiveEntityNames(type);
        for (String entity : registeredEntities) {
            if (!repositoryEntities.contains(entity)) {
                this.cleanEntity(type, entity, true, false);
            }
            repositoryEntities.remove(entity);
        }
        for (String entity : repositoryEntities) {
            this.cleanEntity(type, entity, false, true);
        }
    }

    private void cleanOrphanedServiceAssemblies() throws Exception {
        List<String> serversAndClusters = this.mRegistry.getGenericQuery().getServers();
        serversAndClusters.addAll(this.mRegistry.getGenericQuery().getClusters());
        for (String sc : serversAndClusters) {
            this.cleanOrphanedServiceAssemblies(sc);
        }
    }

    private void cleanOrphanedServiceAssemblies(String target) throws Exception {
        ServiceAssemblyQuery saQuery = this.mRegistry.getServiceAssemblyQuery(target);
        List sas = saQuery.getServiceAssemblies();
        for (String sa : sas) {
            ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(sa);
            if (saInfo.getStatus() != ServiceAssemblyState.UNKNOWN) continue;
            this.mRegistry.getUpdater().removeServiceAssembly(target, sa);
        }
    }
}

