/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.descriptor.Component;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.registry.data.ServiceUnitInfoImpl;
import com.sun.jbi.management.registry.xml.ComponentRefType;
import com.sun.jbi.management.registry.xml.Components;
import com.sun.jbi.management.registry.xml.DomainComponentType;
import com.sun.jbi.management.registry.xml.DomainEntityType;
import com.sun.jbi.management.registry.xml.DomainSharedLibraryType;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.InstalledComponentsListType;
import com.sun.jbi.management.registry.xml.Jbi;
import com.sun.jbi.management.registry.xml.ObjectFactory;
import com.sun.jbi.management.registry.xml.ObjectTranslator;
import com.sun.jbi.management.registry.xml.RegistryImpl;
import com.sun.jbi.management.registry.xml.ServiceAssemblies;
import com.sun.jbi.management.registry.xml.SharedLibraries;
import com.sun.jbi.management.registry.xml.SharedLibraryRefType;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.LockManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;

public class ComponentQueryImpl
implements ComponentQuery {
    private Jbi mJbiRegistry;
    private RegistryImpl mRegistry;
    private boolean mValidate;
    private ManagementContext mMgtCtx;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private GenericQueryImpl mGenQuery;
    private ObjectFactory mObjectFactory;
    private String mTarget;
    private Component mComponentInstance;
    private LockManager mRegObjLM;
    private static String TARGET_DOMAIN = "domain";

    public ComponentQueryImpl(Jbi jbi, ManagementContext mgtCtx, boolean validate, String targetName, RegistryImpl registry) throws RegistryException {
        this.mTarget = targetName;
        this.mJbiRegistry = jbi;
        this.mRegistry = registry;
        this.mValidate = validate;
        this.mMgtCtx = mgtCtx;
        ComponentQueryImpl componentQueryImpl = this;
        this.mLogger = componentQueryImpl.mMgtCtx.getLogger();
        ComponentQueryImpl componentQueryImpl2 = this;
        this.mTranslator = componentQueryImpl2.mMgtCtx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mGenQuery = (GenericQueryImpl)this.mRegistry.getGenericQuery();
        this.mObjectFactory = new ObjectFactory();
        this.mRegObjLM = registry.getRegistryObjectLockManager();
    }

    public List<String> getComponentIds(ComponentType type) {
        List<String> list = new ArrayList<String>();
        try {
            switch (type) {
                case ALL: {
                    list = this.getSharedLibraries(this.getAllComponents());
                    break;
                }
                case BINDINGS_AND_ENGINES: {
                    list = this.getAllComponents();
                    break;
                }
                case BINDING: {
                    list = this.getBindings();
                    break;
                }
                case ENGINE: {
                    list = this.getEngines();
                    break;
                }
                case SHARED_LIBRARY: {
                    list = this.getSharedLibraries(list);
                }
            }
        }
        catch (RegistryException rex) {
            this.mLogger.severe(rex.getMessage());
        }
        return list;
    }

    public List<String> getComponentIds(ComponentType type, ComponentState status) {
        List<String> list = new ArrayList<String>();
        try {
            switch (type) {
                case ALL: {
                    list = this.getSharedLibraries(this.getAllComponents(status), status);
                    break;
                }
                case BINDINGS_AND_ENGINES: {
                    list = this.getAllComponents(status);
                    break;
                }
                case BINDING: {
                    list = this.getBindings(status);
                    break;
                }
                case ENGINE: {
                    list = this.getEngines(status);
                    break;
                }
                case SHARED_LIBRARY: {
                    list = this.getSharedLibraries(list, status);
                }
            }
        }
        catch (RegistryException rex) {
            this.mLogger.severe(rex.getMessage());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo getComponentInfo(String componentName) {
        try {
            this.mLogger.log(Level.FINEST, "Registry retrieving component information for {0} on target {1}", new Object[]{componentName, this.mTarget});
            if (this.mGenQuery.isComponentRegistered(componentName)) {
                ComponentInfo compInfo = null;
                this.mRegObjLM.acquireReadLock();
                try {
                    if (TARGET_DOMAIN.equals(this.mTarget)) {
                        compInfo = ObjectTranslator.getRegistryComponent(componentName, this.mGenQuery);
                        ((ComponentInfoImpl)compInfo).setStatus(this.getStatus(componentName));
                    }
                    ComponentRefType compRef = this.mGenQuery.getComponent(componentName, this.mTarget);
                    compInfo = ObjectTranslator.getRegistryComponent(compRef, this.mGenQuery);
                    if (compInfo != null) {
                    }
                }
                finally {
                    this.mRegObjLM.releaseReadLock();
                    return compInfo;
                }
            }
            this.mLogger.log(Level.FINEST, "Component {0} not registered in domain", componentName);
        }
        catch (Exception rex) {
            rex.printStackTrace();
            this.mLogger.severe(rex.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo getSharedLibraryInfo(String sharedLibraryName) {
        block6: {
            try {
                if (!this.mGenQuery.isSharedLibraryRegistered(sharedLibraryName)) break block6;
                if (TARGET_DOMAIN.equals(this.mTarget)) {
                    ComponentInfo slInfo = ObjectTranslator.getRegistrySharedLibrary(this.mGenQuery, sharedLibraryName);
                    return slInfo;
                }
                ComponentInfo slInfo = null;
                this.mRegObjLM.acquireReadLock();
                try {
                    SharedLibraryRefType slRef = this.mGenQuery.getSharedLibrary(sharedLibraryName, this.mTarget);
                    slInfo = ObjectTranslator.getRegistrySharedLibrary(this.mGenQuery, slRef);
                }
                finally {
                    this.mRegObjLM.releaseReadLock();
                }
                return slInfo;
            }
            catch (RegistryException rex) {
                this.mLogger.severe(rex.getMessage());
            }
        }
        return null;
    }

    public List getDependentComponentIds(String sharedLibraryName) {
        ArrayList<String> depComponents = new ArrayList<String>();
        try {
            if (this.mGenQuery.isSharedLibraryRegistered(sharedLibraryName)) {
                List<String> allComponents = this.getAllComponents();
                for (String component : allComponents) {
                    com.sun.jbi.management.descriptor.Jbi jbi = this.mGenQuery.getComponentJbi(component);
                    List<Component.SharedLibrary> slList = jbi.getComponent().getSharedLibraryList();
                    for (Component.SharedLibrary sl : slList) {
                        if (!sl.getContent().equals(sharedLibraryName)) continue;
                        depComponents.add(component);
                    }
                }
            }
        }
        catch (RegistryException rex) {
            this.mLogger.severe(rex.getMessage());
        }
        return depComponents;
    }

    public ComponentState getStatus(String componentName) throws JBIException {
        if (TARGET_DOMAIN.equals(this.mTarget)) {
            List<String> targets = this.mGenQuery.getServersInstallingComponent(componentName);
            targets.addAll(this.mGenQuery.getClustersInstallingComponent(componentName));
            ArrayList<ComponentState> states = new ArrayList<ComponentState>();
            for (String target : targets) {
                states.add(this.mGenQuery.getComponentState(componentName, target));
            }
            return ComponentState.computeEffectiveState(states);
        }
        return this.mGenQuery.getComponentState(componentName, this.mTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<String> getAllComponents() throws RegistryException {
        components = new ArrayList<String>();
        compNames = new ArrayList<String>();
        if (!ComponentQueryImpl.TARGET_DOMAIN.equals(this.mTarget)) {
            this.mRegObjLM.acquireReadLock();
            try {
                target = null;
                target = this.getTarget(this.mTarget);
                if (target == null) ** GOTO lbl35
                compRefs = target.getComponentRef();
                for (ComponentRefType compRef : compRefs) {
                    compName = compRef.getNameRef();
                    compNames.add(compName);
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        } else {
            this.mRegObjLM.acquireReadLock();
            try {
                compList = this.getDomainComponents();
                for (DomainComponentType comp : compList) {
                    compName = comp.getName();
                    compNames.add(compName);
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        for (String compName : compNames) {
            if (!this.mGenQuery.isComponentRegistered(compName)) continue;
            components.add(compName);
        }
        return components;
    }

    private List<String> getBindings() throws RegistryException {
        List<String> components = this.getAllComponents();
        ArrayList<String> bindings = new ArrayList<String>();
        for (String compName : components) {
            if (!this.mGenQuery.isComponentRegistered(compName) || this.mGenQuery.getComponentType(compName) != ComponentType.BINDING) continue;
            bindings.add(compName);
        }
        return bindings;
    }

    private List<String> getEngines() throws RegistryException {
        List<String> components = this.getAllComponents();
        ArrayList<String> engines = new ArrayList<String>();
        for (String compName : components) {
            if (!this.mGenQuery.isComponentRegistered(compName) || this.mGenQuery.getComponentType(compName) != ComponentType.ENGINE) continue;
            engines.add(compName);
        }
        return engines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<String> getSharedLibraries(List<String> list) throws RegistryException {
        if (list == null) {
            list = new ArrayList<String>();
        }
        slNames = new ArrayList<String>();
        if (!ComponentQueryImpl.TARGET_DOMAIN.equals(this.mTarget)) {
            target = null;
            this.mRegObjLM.acquireReadLock();
            try {
                target = this.getTarget(this.mTarget);
                if (target == null) ** GOTO lbl34
                slRefs = target.getSharedLibraryRef();
                for (SharedLibraryRefType slRef : slRefs) {
                    slName = slRef.getNameRef();
                    slNames.add(slName);
                }
            }
            catch (RegistryException rex) {
                throw rex;
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        } else {
            this.mRegObjLM.acquireReadLock();
            try {
                slList = this.getDomainSharedLibraries();
                for (DomainSharedLibraryType sl : slList) {
                    slName = sl.getName();
                    slNames.add(slName);
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        for (String slName : slNames) {
            if (!this.mGenQuery.isSharedLibraryRegistered(slName)) continue;
            list.add(slName);
        }
        return list;
    }

    private List<String> getSharedLibraries(List<String> list, ComponentState status) throws RegistryException {
        if (list == null) {
            list = new ArrayList<String>();
        }
        ArrayList<String> slNames = new ArrayList<String>();
        if (!TARGET_DOMAIN.equals(this.mTarget)) {
            if (ComponentState.SHUTDOWN == status) {
                InstalledComponentsListType target = null;
                this.mRegObjLM.acquireReadLock();
                try {
                    target = this.getTarget(this.mTarget);
                    if (target != null) {
                        List<SharedLibraryRefType> slRefs = target.getSharedLibraryRef();
                        for (SharedLibraryRefType slRef : slRefs) {
                            String slName = slRef.getNameRef();
                            slNames.add(slName);
                        }
                    }
                }
                catch (RegistryException rex) {
                    throw rex;
                }
                finally {
                    this.mRegObjLM.releaseReadLock();
                }
                for (String slName : slNames) {
                    if (!this.mGenQuery.isSharedLibraryRegistered(slName)) continue;
                    list.add(slName);
                }
            }
        } else {
            return this.getSharedLibraries(list);
        }
        return list;
    }

    private List<String> getAllComponents(ComponentState status) throws RegistryException {
        ArrayList<String> components = new ArrayList();
        ArrayList<String> compNames = new ArrayList<String>();
        if (!TARGET_DOMAIN.equals(this.mTarget)) {
            InstalledComponentsListType target = null;
            this.mRegObjLM.acquireReadLock();
            try {
                target = this.getTarget(this.mTarget);
                if (target != null) {
                    List<ComponentRefType> compRefs = target.getComponentRef();
                    for (ComponentRefType compRef : compRefs) {
                        ComponentState state = ComponentState.valueOfString((String)compRef.getState().value());
                        if (!state.equals((Object)status)) continue;
                        String compName = compRef.getNameRef();
                        compNames.add(compName);
                    }
                }
            }
            catch (RegistryException rex) {
                throw rex;
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
            for (String compName : compNames) {
                if (!this.mGenQuery.isComponentRegistered(compName)) continue;
                components.add(compName);
            }
        } else {
            components = this.getAllComponents();
        }
        return components;
    }

    private List<String> getBindings(ComponentState status) throws RegistryException {
        List<String> components = this.getAllComponents(status);
        ArrayList<String> bindings = new ArrayList<String>();
        for (String compName : components) {
            if (this.mGenQuery.getComponentType(compName) != ComponentType.BINDING) continue;
            bindings.add(compName);
        }
        return bindings;
    }

    private List<String> getEngines(ComponentState status) throws RegistryException {
        List<String> components = this.getAllComponents(status);
        ArrayList<String> engines = new ArrayList<String>();
        for (String compName : components) {
            if (this.mGenQuery.getComponentType(compName) != ComponentType.ENGINE) continue;
            engines.add(compName);
        }
        return engines;
    }

    private InstalledComponentsListType getTarget(String targetName) throws RegistryException {
        InstalledComponentsListType target = null;
        if (this.mGenQuery.isTargetServer(targetName)) {
            List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
            for (InstalledComponentsListType server : servers) {
                if (!server.getNameRef().equals(targetName)) continue;
                target = server;
            }
        } else if (this.mGenQuery.isTargetCluster(targetName)) {
            List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
            for (InstalledComponentsListType cluster : clusters) {
                if (!cluster.getNameRef().equals(targetName)) continue;
                target = cluster;
            }
        }
        if (target == null) {
            this.mLogger.finest(this.mTranslator.getString("JBI_ADMIN_UNKNOWN_TARGET", (Object)this.mTarget));
        }
        return target;
    }

    private List<DomainComponentType> getDomainComponents() throws RegistryException {
        Components compType = this.mJbiRegistry.getComponents();
        if (compType != null) {
            return compType.getComponent();
        }
        return new ArrayList<DomainComponentType>();
    }

    private List<DomainSharedLibraryType> getDomainSharedLibraries() throws RegistryException {
        SharedLibraries slType = this.mJbiRegistry.getSharedLibraries();
        if (slType != null) {
            return slType.getSharedLibrary();
        }
        return new ArrayList<DomainSharedLibraryType>();
    }

    private List<DomainEntityType> getDomainServiceAssemblies() throws RegistryException {
        ServiceAssemblies saType = this.mJbiRegistry.getServiceAssemblies();
        if (saType != null) {
            return saType.getServiceAssembly();
        }
        return new ArrayList<DomainEntityType>();
    }

    private void updateServiceUnits(List<ServiceUnitInfo> suList, String componentName) {
        for (ServiceUnitInfo suInfo : suList) {
            String suRelPath = suInfo.getServiceAssemblyName() + File.separator + suInfo.getName();
            String suArchiveDir = this.mRegistry.getRepository().findArchiveDirectory(ArchiveType.SERVICE_UNIT, suRelPath);
            String filePath = suArchiveDir + File.separator + componentName;
            ((ServiceUnitInfoImpl)suInfo).setFilePath(filePath);
        }
    }
}

