/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarException;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class JarFactory {
    private byte[] mBuffer;
    private String mDir;

    public JarFactory(String dir) {
        this.mDir = dir;
        this.mBuffer = new byte[8092];
    }

    public void unJar(File jarFile) throws IOException, JarException, ZipException {
        FileInputStream fis = new FileInputStream(jarFile);
        JarInputStream jis = new JarInputStream(fis);
        this.unJar(jis);
        jis.close();
    }

    public void unJar(ZipInputStream zis) throws IOException, ZipException {
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            this.getEntry(zis, zipEntry);
            zipEntry = zis.getNextEntry();
        }
    }

    public String getEntry(ZipInputStream zis, ZipEntry entry) throws IOException {
        String entryName = entry.getName();
        if (entryName.endsWith("/")) {
            new File(this.mDir, entryName).mkdirs();
            return entryName;
        }
        File f = new File(this.mDir, entryName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream fostream = new FileOutputStream(f);
        int n = 0;
        while ((n = zis.read(this.mBuffer)) > 0) {
            fostream.write(this.mBuffer, 0, n);
        }
        try {
            fostream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryName;
    }
}

