/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.RuntimeConfiguration;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.security.KeyStoreUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;

public class InstanceConfiguration
extends RuntimeConfiguration {
    protected ConcurrentHashMap<String, Object> mOverridenAttributes;

    public InstanceConfiguration(ModelMBeanInfo mbeanInfo, ConfigurationCategory category) throws Exception {
        super(mbeanInfo, category, null);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.persistDomainConfig();
        try {
            this.notifyListenersOfAttributeChange(attribute);
            GenericQuery query = this.getRegistry().getGenericQuery();
            Updater updater = this.getRegistry().getUpdater();
            String attrValue = attribute.getValue() == null ? "null" : attribute.getValue().toString();
            String domainValue = query.getAttribute("domain", this.mCategory, attribute.getName());
            if (domainValue != null && attrValue.toString().equals(domainValue)) {
                updater.deleteAttribute(this.mCategory, attribute.getName());
            } else {
                String persistAttrValue = attrValue;
                if (this.isPassword(attribute.getName())) {
                    KeyStoreUtil ksUtil = this.getPlatformContext().getKeyStoreUtil();
                    persistAttrValue = ksUtil.encrypt(attrValue);
                }
                updater.setAttribute(this.mCategory, attribute.getName(), persistAttrValue);
            }
        }
        catch (Exception ex) {
            String errMsg = InstanceConfiguration.getTranslator().getString("JBI_ADMIN_SET_CFG_ATTRIB_FAILED", (Object)attribute.getName(), (Object)this.mCategory.toString(), (Object)ex.getMessage());
            JBIException jbiEx = new JBIException(errMsg);
            throw new MBeanException((Exception)jbiEx, errMsg);
        }
    }

    @Override
    public void deleteOverride(String attrName) throws Exception {
        Updater updater = this.getRegistry().getUpdater();
        updater.deleteAttribute(this.mCategory, attrName);
    }
}

