/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.Util;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class JBIRemoteException
extends Exception
implements Serializable {
    protected StringBuffer mCauseStackTrace;
    protected String[] mCauseMessageTrace;
    static final long serialVersionUID = 4431187824092164710L;

    public JBIRemoteException(String aMessage) {
        this(aMessage, null);
    }

    public JBIRemoteException(Throwable aCause) {
        this(null, aCause);
    }

    public JBIRemoteException(String aMessage, Throwable aCause) {
        super(aMessage);
        this.initCauseTrace(aCause);
    }

    public JBIRemoteException(JBIRemoteException exception) {
        this.mCauseMessageTrace = exception.getCauseMessageTrace();
        this.mCauseStackTrace = exception.getCauseStackTrace();
    }

    public void initCauseTrace(Throwable aCause) {
        this.mCauseStackTrace = null;
        this.mCauseMessageTrace = null;
        if (aCause == null) {
            return;
        }
        StringWriter traceWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(traceWriter);
        aCause.printStackTrace(printWriter);
        printWriter.close();
        this.mCauseStackTrace = traceWriter.getBuffer();
        ArrayList<String> list = new ArrayList<String>();
        for (Throwable nextCause = aCause; nextCause != null; nextCause = nextCause.getCause()) {
            list.add(nextCause.getMessage());
        }
        this.mCauseMessageTrace = list.toArray(new String[0]);
    }

    @Override
    public String getMessage() {
        String mainMsg = super.getMessage();
        if (this.mCauseMessageTrace == null || this.mCauseMessageTrace.length <= 0) {
            return mainMsg;
        }
        boolean hasMainMsg = mainMsg != null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        if (hasMainMsg) {
            msgWriter.println(mainMsg);
            msgWriter.print(Util.getCommonI18NBundle().getMessage("jbi.remote.exception.msg.root.cause.msg", this.mCauseMessageTrace[0]));
        } else {
            msgWriter.print(this.mCauseMessageTrace[0]);
        }
        for (int i = 1; i < this.mCauseMessageTrace.length; ++i) {
            msgWriter.println();
            msgWriter.print(Util.getCommonI18NBundle().getMessage("jbi.remote.exception.msg.root.cause.msg", this.mCauseMessageTrace[i]));
        }
        msgWriter.close();
        return stringWriter.toString();
    }

    public String[] getCauseMessageTrace() {
        return this.mCauseMessageTrace;
    }

    public StringBuffer getCauseStackTrace() {
        return this.mCauseStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            if (this.mCauseStackTrace != null) {
                s.println(this.mCauseStackTrace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        PrintStream printStream = s;
        synchronized (printStream) {
            if (this.mCauseStackTrace != null) {
                s.println(this.mCauseStackTrace.toString());
            }
        }
    }

    public JBIManagementMessage extractJBIManagementMessage() {
        String exMessage = null;
        String[] msgs = this.getCauseMessageTrace();
        if (msgs != null && msgs.length > 0) {
            exMessage = msgs[0];
        }
        if (exMessage == null) {
            return null;
        }
        JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage(exMessage);
        return mgmtMsg;
    }

    public static JBIRemoteException filterJmxExceptions(Exception jmxEx) {
        Throwable rootCause;
        Exception cause = rootCause = jmxEx;
        while (cause != null && (cause instanceof MBeanException || cause instanceof RuntimeMBeanException || cause instanceof RuntimeOperationsException)) {
            cause = rootCause = cause.getCause();
        }
        if (rootCause instanceof JBIRemoteException) {
            return (JBIRemoteException)rootCause;
        }
        return new JBIRemoteException(rootCause);
    }
}

