/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.ESBResultFormatter;
import com.sun.jbi.ui.common.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JBIManagementMessage {
    public static final String FAILED = "FAILED";
    public static final String SUCCESS = "SUCCESS";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String UNKNOWN = "UNKNOWN";
    private FrameworkTaskResult mFrameworkTaskResult;
    private List mCompTaskResultList;

    protected JBIManagementMessage() {
        this.initMessageData();
    }

    private void initMessageData() {
        this.mFrameworkTaskResult = null;
        this.mCompTaskResultList = new ArrayList();
    }

    protected void setFrameworkTaskResult(FrameworkTaskResult frameworkTaskResult) {
        this.mFrameworkTaskResult = frameworkTaskResult;
    }

    protected FrameworkTaskResult getFrameworkTaskResult() {
        return this.mFrameworkTaskResult;
    }

    protected List getComponentTaskResultList() {
        return this.mCompTaskResultList;
    }

    protected List getSortedComponentTaskResultList() {
        try {
            Collections.sort(this.mCompTaskResultList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ComponentTaskResult)o1).getComponentId().compareTo(((ComponentTaskResult)o2).getComponentId());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupEx) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mCompTaskResultList;
    }

    public boolean isSuccessMsg() {
        String result = this.mFrameworkTaskResult.getResult();
        return SUCCESS.equalsIgnoreCase(result);
    }

    public boolean isFailedMsg() {
        return !this.isSuccessMsg();
    }

    public boolean isWarningMsg() {
        return this.isSuccessMsg() && this.isWarningMsgType();
    }

    public String getMessageType() {
        String msgType = this.mFrameworkTaskResult.getTaskResultInfo().getMessageType();
        return msgType;
    }

    public boolean isWarningMsgType() {
        return WARNING.equalsIgnoreCase(this.getMessageType());
    }

    public boolean isInfoMsgType() {
        return INFO.equalsIgnoreCase(this.getMessageType());
    }

    public boolean isErrorMsgType() {
        return ERROR.equalsIgnoreCase(this.getMessageType());
    }

    public boolean isExceptionMsgType() {
        block3: {
            block2: {
                String type = this.getMessageType();
                if (type == null) break block2;
                if (UNKNOWN.equalsIgnoreCase(type)) break block2;
                if (!EXCEPTION.equalsIgnoreCase(type)) break block3;
            }
            return this.getFrameworkTaskResult().isException();
        }
        return false;
    }

    public void printMessage(PrintStream s) {
        PrintWriter writer = new PrintWriter(s);
        this.printMessage(writer);
    }

    public String getDebugMessage() {
        StringWriter msgBuffer = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(msgBuffer);
        String verboseString = "";
        msgWriter.println(Util.getCommonI18NBundle().getMessage("jbi.mgmt.msg.debug.fw.msg.header"));
        String formattedFrameworkMsg = Util.getCommonI18NBundle().getMessage("jbi.mgmt.msg.debug.fw.msg", new Object[]{this.mFrameworkTaskResult.getTaskId(), this.mFrameworkTaskResult.getResult(), this.mFrameworkTaskResult.getMessage()});
        msgWriter.println(formattedFrameworkMsg);
        msgWriter.println(Util.getCommonI18NBundle().getMessage("jbi.mgmt.msg.debug.comp.msg.header"));
        List compTaskResultList = this.getComponentTaskResultList();
        for (int i = 0; i < compTaskResultList.size(); ++i) {
            ComponentTaskResult compTaskResult = (ComponentTaskResult)compTaskResultList.get(i);
            String compName = compTaskResult.getComponentId();
            String compMsgTitle = Util.getCommonI18NBundle().getMessage("jbi.mgmt.msg.debug.for.comp", compName);
            msgWriter.println(compMsgTitle);
            String formattedCompMsg = Util.getCommonI18NBundle().getMessage("jbi.mgmt.msg.debug.comp.msg", new Object[]{compTaskResult.getTaskId(), compTaskResult.getResult(), compTaskResult.getMessage()});
            msgWriter.println(formattedCompMsg);
        }
        this.closeWriter(msgWriter);
        this.closeWriter(msgBuffer);
        return msgBuffer.getBuffer().toString();
    }

    public void printDebugMessage(PrintWriter writer) {
        String outMsg = this.getDebugMessage();
        writer.println(outMsg);
    }

    protected void closeWriter(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void printMessageList(PrintWriter out, List msgList) {
        String msg = (String)msgList.get(0);
        out.print(msg);
        for (int i = 1; i < msgList.size(); ++i) {
            out.println();
            msg = (String)msgList.get(i);
            out.print(msg);
        }
    }

    protected List getAllMessagesForComponent(ComponentTaskResult compTaskResult) {
        boolean compFormat = true;
        if (compTaskResult == null) {
            return new ArrayList();
        }
        return compTaskResult.getTaskResultInfo().getAllFormattedMessages(compFormat);
    }

    public String getMessageDeprecated(String level) {
        if (!level.equalsIgnoreCase("normal") && !level.equalsIgnoreCase("terse")) {
            level = "verbose";
        }
        StringWriter msgBuffer = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(msgBuffer);
        StringWriter fwMsgBuffer = new StringWriter();
        PrintWriter fwMsgWriter = new PrintWriter(fwMsgBuffer);
        StringWriter compMsgBuffer = new StringWriter();
        PrintWriter compMsgWriter = new PrintWriter(compMsgBuffer);
        boolean containsFwMsgs = false;
        boolean containsCompMsgs = false;
        boolean compFormat = true;
        List fwMsgList = this.getFrameworkTaskResult().getTaskResultInfo().getAllFormattedMessages(!compFormat);
        if (fwMsgList != null && fwMsgList.size() > 0) {
            this.printMessageList(fwMsgWriter, fwMsgList);
            containsFwMsgs = true;
        }
        boolean firstCompMsgPrinted = false;
        List compTaskResultList = this.getSortedComponentTaskResultList();
        for (int i = 0; i < compTaskResultList.size(); ++i) {
            ComponentTaskResult compTaskResult = (ComponentTaskResult)compTaskResultList.get(i);
            String compName = compTaskResult.getComponentId();
            List compMsgList = this.getAllMessagesForComponent(compTaskResult);
            if (compMsgList == null || compMsgList.size() <= 0) continue;
            if (firstCompMsgPrinted) {
                compMsgWriter.println();
            }
            String compMsgTitle = Util.getCommonI18NBundle().getMessage("jbi.result.comp.msg.from.comp", compName);
            compMsgWriter.println(compMsgTitle);
            this.printMessageList(compMsgWriter, compMsgList);
            firstCompMsgPrinted = true;
            containsCompMsgs = true;
        }
        this.closeWriter(fwMsgWriter);
        this.closeWriter(compMsgWriter);
        this.closeWriter(fwMsgBuffer);
        this.closeWriter(compMsgBuffer);
        if (containsFwMsgs) {
            msgWriter.print(fwMsgBuffer.getBuffer().toString());
        }
        if (containsCompMsgs) {
            if (containsFwMsgs) {
                msgWriter.println();
            }
            msgWriter.print(compMsgBuffer.getBuffer().toString());
        }
        this.closeWriter(msgWriter);
        this.closeWriter(msgBuffer);
        return msgBuffer.getBuffer().toString();
    }

    public String getMessage(String level) {
        if (!level.equalsIgnoreCase("normal") && !level.equalsIgnoreCase("terse")) {
            level = "verbose";
        }
        ESBResultFormatter formatter = new ESBResultFormatter(level);
        return formatter.getFormattedESBResult(this);
    }

    public String getMessage() {
        return this.getMessage("verbose");
    }

    public void printMessage(PrintWriter writer) {
        String outMsg = this.getMessage();
        writer.println(outMsg);
    }

    public void printStackTrace(PrintStream s) {
        PrintWriter writer = new PrintWriter(s, true);
        this.printStackTrace(writer);
    }

    public static void printWithIndentation(String prefix, String msg, PrintWriter writer) {
        if (msg == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(msg));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                writer.println(prefix + line);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void printStackTrace(PrintWriter writer) {
        String fwSTPrefix = Util.getCommonI18NBundle().getMessage("jbi.mgmt.stack.fw.stack.prefix");
        String compSTPrefix = Util.getCommonI18NBundle().getMessage("jbi.mgmt.stack.comp.stack.prefix");
        writer.println(Util.getCommonI18NBundle().getMessage("jbi.mgmt.stack.fw.stack.header"));
        writer.print(this.mFrameworkTaskResult.getMessage());
        String frameworkStack = this.mFrameworkTaskResult.getStackTrace();
        JBIManagementMessage.printWithIndentation(fwSTPrefix, frameworkStack, writer);
        writer.println(Util.getCommonI18NBundle().getMessage("jbi.mgmt.stack.comp.stack.header"));
        List compTaskResultList = this.getComponentTaskResultList();
        for (int i = 0; i < compTaskResultList.size(); ++i) {
            ComponentTaskResult compTaskResult = (ComponentTaskResult)compTaskResultList.get(i);
            String compName = compTaskResult.getComponentId();
            String compMsgTitle = Util.getCommonI18NBundle().getMessage("jbi.mgmt.stack.for.comp", compName);
            writer.println(compMsgTitle);
            String compStack = compTaskResult.getStackTrace();
            writer.print(compTaskResult.getMessage());
            JBIManagementMessage.printWithIndentation(compSTPrefix, compStack, writer);
        }
    }

    public String getStackTrace() {
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)strWriter, true);
        this.printStackTrace(writer);
        writer.close();
        return strWriter.getBuffer().toString();
    }

    private void addToComponentResultList(ComponentTaskResult compTaskResult) {
        if (compTaskResult == null) {
            return;
        }
        this.mCompTaskResultList.add(compTaskResult);
    }

    public static JBIManagementMessage createJBIManagementMessage(String xmlText) {
        JBIManagementMessageUnmarshaller unmarshaller = new JBIManagementMessageUnmarshaller();
        try {
            return unmarshaller.unmarshal(xmlText);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static String getL10NMessageType(String msgType) {
        String l10nMsgType = null;
        l10nMsgType = ERROR.equalsIgnoreCase(msgType) ? Util.getCommonI18NBundle().getMessage("jbi.result.msg.type.error") : (WARNING.equalsIgnoreCase(msgType) ? Util.getCommonI18NBundle().getMessage("jbi.result.msg.type.warning") : (INFO.equalsIgnoreCase(msgType) ? Util.getCommonI18NBundle().getMessage("jbi.result.msg.type.info") : Util.getCommonI18NBundle().getMessage("jbi.result.msg.type.unknown")));
        return l10nMsgType;
    }

    public static JBIManagementMessage createJBIManagementMessage(String taskId, Map<String, String> responseMap, boolean requireAllSuccess) {
        Set<String> appVarNames = responseMap.keySet();
        ArrayList<MessageInfo> frmwkMessageInfos = new ArrayList<MessageInfo>();
        ArrayList<ExceptionInfo> frmwkExceptionInfos = new ArrayList<ExceptionInfo>();
        HashMap<String, ArrayList<MessageInfo>> instanceMessageInfoMap = new HashMap<String, ArrayList<MessageInfo>>();
        HashMap<String, ArrayList<ExceptionInfo>> instanceExceptionInfoMap = new HashMap<String, ArrayList<ExceptionInfo>>();
        ArrayList<Boolean> taskResults = new ArrayList<Boolean>();
        ArrayList<String> msgTypes = new ArrayList<String>();
        for (String appVarName : appVarNames) {
            String jbiXmlStr = responseMap.get(appVarName);
            JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage(jbiXmlStr);
            boolean instAppMsgInfoAdded = false;
            boolean fwkAppMsgInfoAdded = false;
            boolean instAppExpInfoAdded = false;
            boolean fwkAppExpInfoAdded = false;
            if (mgmtMsg != null) {
                MessageInfo appVarInfo;
                MessageInfo appVarInfo2;
                taskResults.add(mgmtMsg.isSuccessMsg());
                TaskResultInfo taskResultInfo = mgmtMsg.getFrameworkTaskResult().getTaskResultInfo();
                msgTypes.add(taskResultInfo.getMessageType());
                List msgInfos = taskResultInfo.getStatusMessageInfoList();
                List exInfos = taskResultInfo.getExceptionInfoList();
                boolean processingInstanceMsgs = false;
                String instanceName = null;
                for (MessageInfo msgInfo : msgInfos) {
                    if (msgInfo.getI18nId().equals("JBI_INSTANCE_NAME")) {
                        processingInstanceMsgs = true;
                        instanceName = msgInfo.getLocalizedMsg();
                    }
                    if (processingInstanceMsgs) {
                        ArrayList<MessageInfo> instMsgInfoList = (ArrayList<MessageInfo>)instanceMessageInfoMap.get(instanceName);
                        if (instMsgInfoList == null) {
                            instMsgInfoList = new ArrayList<MessageInfo>();
                            instanceMessageInfoMap.put(instanceName, instMsgInfoList);
                            instMsgInfoList.add(msgInfo);
                            continue;
                        }
                        if (!instAppMsgInfoAdded) {
                            appVarInfo2 = JBIManagementMessage.createAppVarMarkerMsgInfo(appVarName);
                            instMsgInfoList.add(appVarInfo2);
                            instAppMsgInfoAdded = true;
                        }
                        instMsgInfoList.add(msgInfo);
                        continue;
                    }
                    if (!fwkAppMsgInfoAdded) {
                        appVarInfo = JBIManagementMessage.createAppVarMarkerMsgInfo(appVarName);
                        frmwkMessageInfos.add(appVarInfo);
                        fwkAppMsgInfoAdded = true;
                    }
                    frmwkMessageInfos.add(msgInfo);
                }
                processingInstanceMsgs = false;
                instanceName = null;
                for (ExceptionInfo exInfo : exInfos) {
                    if (exInfo.getMessageInfo().getI18nId().equals("JBI_INSTANCE_NAME")) {
                        processingInstanceMsgs = true;
                        instanceName = exInfo.getLocalizedMsg();
                    }
                    if (processingInstanceMsgs) {
                        ArrayList<ExceptionInfo> instExInfoList = (ArrayList<ExceptionInfo>)instanceExceptionInfoMap.get(instanceName);
                        if (instExInfoList == null) {
                            instExInfoList = new ArrayList<ExceptionInfo>();
                            instanceExceptionInfoMap.put(instanceName, instExInfoList);
                            instExInfoList.add(exInfo);
                            continue;
                        }
                        if (!instAppExpInfoAdded) {
                            appVarInfo2 = JBIManagementMessage.createAppVarMarkerMsgInfo(appVarName);
                            ExceptionInfo appVarExInfo = new ExceptionInfo("0", appVarInfo2, null);
                            instExInfoList.add(appVarExInfo);
                            instAppExpInfoAdded = true;
                        }
                        instExInfoList.add(exInfo);
                        continue;
                    }
                    if (!fwkAppExpInfoAdded) {
                        appVarInfo = JBIManagementMessage.createAppVarMarkerMsgInfo(appVarName);
                        ExceptionInfo appVarExInfo = new ExceptionInfo("0", appVarInfo, null);
                        frmwkExceptionInfos.add(appVarExInfo);
                        fwkAppExpInfoAdded = true;
                    }
                    frmwkExceptionInfos.add(exInfo);
                }
                continue;
            }
            taskResults.add(false);
            msgTypes.add(ERROR);
            MessageInfo appVarInfo = JBIManagementMessage.createAppVarMarkerMsgInfo(appVarName);
            frmwkMessageInfos.add(appVarInfo);
            MessageInfo exMsgInfo = new MessageInfo("UICMN0000", jbiXmlStr, null);
            frmwkMessageInfos.add(exMsgInfo);
        }
        boolean isSuccess = requireAllSuccess;
        for (Boolean sccss : taskResults) {
            if (!requireAllSuccess) {
                isSuccess |= sccss.booleanValue();
                continue;
            }
            isSuccess &= sccss.booleanValue();
        }
        String effectiveMsgType = INFO;
        if (msgTypes.contains(ERROR) || msgTypes.contains(WARNING)) {
            effectiveMsgType = requireAllSuccess ? (msgTypes.contains(ERROR) ? ERROR : (msgTypes.contains(WARNING) ? WARNING : INFO)) : (isSuccess ? WARNING : ERROR);
        }
        Set instanceNames = instanceMessageInfoMap.keySet();
        for (String instName : instanceNames) {
            frmwkMessageInfos.addAll((Collection)instanceMessageInfoMap.get(instName));
        }
        instanceNames = instanceExceptionInfoMap.keySet();
        for (String instName : instanceNames) {
            frmwkExceptionInfos.addAll((Collection)instanceExceptionInfoMap.get(instName));
        }
        String taskResultStr = isSuccess ? SUCCESS : FAILED;
        TaskResultInfo taskResultInfo = new TaskResultInfo(taskId, taskResultStr, effectiveMsgType, frmwkMessageInfos, frmwkExceptionInfos);
        FrameworkTaskResult taskResult = new FrameworkTaskResult(taskResultInfo, false, Locale.getDefault().toString());
        JBIManagementMessage msg = new JBIManagementMessage();
        msg.setFrameworkTaskResult(taskResult);
        return msg;
    }

    private static MessageInfo createAppVarMarkerMsgInfo(String appVarName) {
        return new MessageInfo("APPLICATION_VARIABLE_NAME", appVarName, null);
    }

    public static class JBIManagementMessageException
    extends Exception {
        JBIManagementMessage mMgmtMsg;

        public JBIManagementMessageException(JBIManagementMessage mgmtMsg) {
            this(mgmtMsg.getMessage(), mgmtMsg);
        }

        public JBIManagementMessageException(String msg, JBIManagementMessage mgmtMsg) {
            super(msg);
            this.mMgmtMsg = mgmtMsg;
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            this.mMgmtMsg.printStackTrace(s);
            super.printStackTrace(s);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            this.mMgmtMsg.printStackTrace(s);
            super.printStackTrace(s);
        }
    }

    public static class JBIManagementMessageUnmarshaller {
        public JBIManagementMessage unmarshal(String xmlText) {
            Document xmlDoc = null;
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                docBuilder.setErrorHandler(new DefaultHandler(){

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        throw new SAXException(e.getMessage());
                    }
                });
                StringReader reader = new StringReader(xmlText);
                InputSource is = new InputSource(reader);
                xmlDoc = docBuilder.parse(is);
            }
            catch (Exception ex) {
                return null;
            }
            if (xmlDoc == null) {
                return null;
            }
            JBIManagementMessage msg = new JBIManagementMessage();
            Element rootEl = DOMUtil.UTIL.getElement(xmlDoc, "jbi-task");
            if (rootEl == null) {
                return null;
            }
            Element taskResultInfo = DOMUtil.UTIL.getElement(xmlDoc, "jbi-task-result");
            if (taskResultInfo == null) {
                return null;
            }
            Element fwInfoEl = DOMUtil.UTIL.getElement(taskResultInfo, "frmwk-task-result");
            if (fwInfoEl == null) {
                return null;
            }
            FrameworkTaskResult fwTaskResult = this.getFrameworkTaskResult(fwInfoEl);
            msg.setFrameworkTaskResult(fwTaskResult);
            NodeList compInfoList = DOMUtil.UTIL.getChildElements(taskResultInfo, "component-task-result");
            if (compInfoList != null) {
                int size = compInfoList.getLength();
                for (int i = 0; i < size; ++i) {
                    Element compInfoElement = (Element)compInfoList.item(i);
                    if (compInfoElement == null) continue;
                    ComponentTaskResult compTaskResult = this.getComponentTaskResult(compInfoElement);
                    msg.addToComponentResultList(compTaskResult);
                }
            }
            return msg;
        }

        private String getFrameworkLocale(Element fwInfoEl) {
            String locale = null;
            Element localeEl = DOMUtil.UTIL.getElement(fwInfoEl, "locale");
            if (localeEl != null) {
                locale = DOMUtil.UTIL.getTextData(localeEl);
            }
            return locale;
        }

        private boolean isCauseComponent(Element fwInfoEl) {
            String value = "NO";
            Element isCauseComponentEl = DOMUtil.UTIL.getElement(fwInfoEl, "is-cause-component");
            value = isCauseComponentEl != null ? DOMUtil.UTIL.getTextData(isCauseComponentEl) : "NO";
            return value.equalsIgnoreCase("YES");
        }

        private boolean isCauseFramework(Element fwInfoEl) {
            String value = "NO";
            Element isCauseFrameworkEl = DOMUtil.UTIL.getElement(fwInfoEl, "is-cause-framework");
            value = isCauseFrameworkEl != null ? DOMUtil.UTIL.getTextData(isCauseFrameworkEl) : "NO";
            return value.equalsIgnoreCase("YES");
        }

        private MessageInfo getMessageInfo(Element msgInfoEl) {
            Element msgEl;
            Object msgInfo = null;
            String id = JBIManagementMessage.UNKNOWN;
            String msg = null;
            ArrayList<String> params = new ArrayList<String>();
            Element idEl = DOMUtil.UTIL.getElement(msgInfoEl, "loc-token");
            if (idEl != null) {
                id = DOMUtil.UTIL.getTextData(idEl);
            }
            if ((msgEl = DOMUtil.UTIL.getElement(msgInfoEl, "loc-message")) != null) {
                msg = DOMUtil.UTIL.getTextData(msgEl);
            }
            NodeList paramElList = DOMUtil.UTIL.getChildElements(msgInfoEl, "loc-param");
            int size = paramElList.getLength();
            params = new ArrayList();
            for (int i = 0; i < size; ++i) {
                Element paramEl = (Element)paramElList.item(i);
                if (paramEl == null) continue;
                String param = DOMUtil.UTIL.getTextData(paramEl);
                params.add(param);
            }
            return new MessageInfo(id, msg, params);
        }

        private ExceptionInfo getExceptionInfo(Element exInfoEl) {
            Element stacktraceEl;
            Element msgInfoEl;
            String level = "-1";
            MessageInfo msgInfo = null;
            String stacktrace = null;
            Element levelEl = DOMUtil.UTIL.getElement(exInfoEl, "nesting-level");
            if (levelEl != null) {
                level = DOMUtil.UTIL.getTextData(levelEl);
            }
            if ((msgInfoEl = DOMUtil.UTIL.getElement(exInfoEl, "msg-loc-info")) != null) {
                msgInfo = this.getMessageInfo(msgInfoEl);
            }
            if ((stacktraceEl = DOMUtil.UTIL.getElement(exInfoEl, "stack-trace")) != null) {
                stacktrace = DOMUtil.UTIL.getTextData(stacktraceEl);
            }
            return new ExceptionInfo(level, msgInfo, stacktrace);
        }

        private TaskResultInfo getTaskResultInfo(Element taskResultInfoEl) {
            Element msgTypeEl;
            Element resultEl;
            String id = JBIManagementMessage.UNKNOWN;
            String result = JBIManagementMessage.UNKNOWN;
            String msgType = JBIManagementMessage.UNKNOWN;
            ArrayList<MessageInfo> msgInfoList = new ArrayList<MessageInfo>();
            ArrayList<ExceptionInfo> exInfoList = new ArrayList<ExceptionInfo>();
            Element idEl = DOMUtil.UTIL.getElement(taskResultInfoEl, "task-id");
            if (idEl != null) {
                id = DOMUtil.UTIL.getTextData(idEl);
            }
            if ((resultEl = DOMUtil.UTIL.getElement(taskResultInfoEl, "task-result")) != null) {
                result = DOMUtil.UTIL.getTextData(resultEl);
            }
            if ((msgTypeEl = DOMUtil.UTIL.getElement(taskResultInfoEl, "message-type")) != null) {
                msgType = DOMUtil.UTIL.getTextData(msgTypeEl);
            }
            NodeList msgInfoElList = DOMUtil.UTIL.getChildElements(taskResultInfoEl, "task-status-msg");
            int msgInfoListSize = msgInfoElList.getLength();
            msgInfoList = new ArrayList();
            for (int i = 0; i < msgInfoListSize; ++i) {
                Element msgInfoEl = (Element)msgInfoElList.item(i);
                if (msgInfoEl == null) continue;
                MessageInfo statusMsgInfo = this.getMessageInfo(msgInfoEl);
                msgInfoList.add(statusMsgInfo);
            }
            NodeList exInfoElList = DOMUtil.UTIL.getChildElements(taskResultInfoEl, "exception-info");
            int exInfoListSize = exInfoElList.getLength();
            exInfoList = new ArrayList();
            for (int i = 0; i < exInfoListSize; ++i) {
                Element exInfoEl = (Element)exInfoElList.item(i);
                if (exInfoEl == null) continue;
                ExceptionInfo exInfo = this.getExceptionInfo(exInfoEl);
                exInfoList.add(exInfo);
            }
            return new TaskResultInfo(id, result, msgType, msgInfoList, exInfoList);
        }

        private FrameworkTaskResult getFrameworkTaskResult(Element fwInfoEl) {
            String locale = null;
            boolean isCuaseFramework = false;
            TaskResultInfo taskResultInfo = null;
            isCuaseFramework = this.isCauseFramework(fwInfoEl);
            locale = this.getFrameworkLocale(fwInfoEl);
            Element taskResultDetailsEl = DOMUtil.UTIL.getElement(fwInfoEl, "task-result-details");
            taskResultInfo = this.getTaskResultInfo(taskResultDetailsEl);
            return new FrameworkTaskResult(taskResultInfo, isCuaseFramework, locale);
        }

        private ComponentTaskResult getComponentTaskResult(Element compInfoEl) {
            String compId = "UNKNOWN COMPONENT";
            TaskResultInfo taskResultInfo = null;
            Element compIdEl = DOMUtil.UTIL.getElement(compInfoEl, "component-name");
            if (compIdEl != null) {
                compId = DOMUtil.UTIL.getTextData(compIdEl);
            }
            Element taskResultDetailsEl = DOMUtil.UTIL.getElement(compInfoEl, "task-result-details");
            taskResultInfo = this.getTaskResultInfo(taskResultDetailsEl);
            return new ComponentTaskResult(taskResultInfo, compId);
        }
    }

    public static class ESBTaskResult {
        private JBITaskResult mCASTaskResult;
        private List mInstTaskResultList;

        public ESBTaskResult() {
            this.mCASTaskResult = new JBITaskResult();
            this.mInstTaskResultList = new ArrayList();
        }

        public ESBTaskResult(JBITaskResult casTaskResult, List instTaskResultList) {
            this.mCASTaskResult = casTaskResult;
            this.mInstTaskResultList = instTaskResultList;
        }

        public JBITaskResult getCASTaskResult() {
            return this.mCASTaskResult;
        }

        public void setCASTaskResult(JBITaskResult casTaskResult) {
            this.mCASTaskResult = casTaskResult;
        }

        public List getInstanceTaskResultList() {
            return this.mInstTaskResultList;
        }

        public void setInstanceTaskResultList(List instTaskResultList) {
            this.mInstTaskResultList = instTaskResultList;
        }
    }

    public static class InstanceTaskResult {
        private String mInstanceName;
        private JBITaskResult mJBITaskResult;

        public InstanceTaskResult() {
            this.mInstanceName = null;
            this.mJBITaskResult = new JBITaskResult();
        }

        public InstanceTaskResult(String instanceName, JBITaskResult jbiTaskResult) {
            this.mInstanceName = instanceName;
            this.mJBITaskResult = jbiTaskResult;
        }

        public String getInstanceName() {
            return this.mInstanceName;
        }

        public void setInstanceName(String instanceName) {
            this.mInstanceName = instanceName;
        }

        public JBITaskResult getJBITaskResult() {
            return this.mJBITaskResult;
        }

        public void setJBITaskResult(JBITaskResult jbiTaskResult) {
            this.mJBITaskResult = jbiTaskResult;
        }
    }

    public static class JBITaskResult {
        private FrameworkTaskResult mFrameworkTaskResult;
        private List mCompTaskResultList;

        public JBITaskResult() {
            this.mFrameworkTaskResult = new FrameworkTaskResult();
            this.mCompTaskResultList = new ArrayList();
        }

        public JBITaskResult(FrameworkTaskResult fwTaskResult, List compTaskResultList) {
            this.mFrameworkTaskResult = fwTaskResult;
            this.mCompTaskResultList = compTaskResultList;
        }

        public FrameworkTaskResult getFrameworkTaskResult() {
            return this.mFrameworkTaskResult;
        }

        public void setFrameworkTaskResult(FrameworkTaskResult fwTaskResult) {
            this.mFrameworkTaskResult = fwTaskResult;
        }

        public List getComponentTaskResultList() {
            return this.mCompTaskResultList;
        }

        public void setComponentTaskResultList(List compTaskResultList) {
            this.mCompTaskResultList = compTaskResultList;
        }
    }

    public static class ComponentTaskResult
    extends AbstractTaskResult {
        private String mComponentId;

        public ComponentTaskResult() {
            this.mComponentId = null;
        }

        public ComponentTaskResult(TaskResultInfo taskResultInfo, String aComponentId) {
            this.setTaskResultInfo(taskResultInfo);
            this.mComponentId = aComponentId;
        }

        public String getComponentId() {
            return this.mComponentId;
        }

        public String getComponentName() {
            return this.getComponentId();
        }
    }

    public static class FrameworkTaskResult
    extends AbstractTaskResult {
        private boolean mIsCauseFramework;
        private String mLocale;

        public FrameworkTaskResult() {
            this.mIsCauseFramework = false;
            this.mLocale = Locale.getDefault().toString();
        }

        public FrameworkTaskResult(TaskResultInfo taskResultInfo, boolean isCauseFramework, String locale) {
            this.setTaskResultInfo(taskResultInfo);
            this.mIsCauseFramework = isCauseFramework;
            this.mLocale = locale;
        }

        public String getLocale() {
            return this.mLocale;
        }

        public void setLocale(String locale) {
            this.mLocale = locale;
        }

        public void setIsCauseFramework(boolean isCauseFramework) {
            this.mIsCauseFramework = isCauseFramework;
        }

        public boolean isCauseFramework() {
            return this.mIsCauseFramework;
        }

        public boolean isCauseComponent() {
            return !this.isCauseFramework();
        }
    }

    public static abstract class AbstractTaskResult {
        private TaskResultInfo mTaskResultInfo = new TaskResultInfo();

        protected AbstractTaskResult() {
        }

        public TaskResultInfo getTaskResultInfo() {
            return this.mTaskResultInfo;
        }

        public void setTaskResultInfo(TaskResultInfo taskResultInfo) {
            this.mTaskResultInfo = taskResultInfo;
        }

        public String getTaskId() {
            return this.getTaskResultInfo().getTaskId();
        }

        public String getResult() {
            return this.getTaskResultInfo().getResult();
        }

        public String getMessage() {
            return this.getTaskResultInfo().getMessage();
        }

        public boolean isException() {
            return this.getTaskResultInfo().isException();
        }

        public String getStackTrace() {
            return this.getTaskResultInfo().getStackTrace();
        }
    }

    public static class TaskResultInfo {
        private String mTaskId;
        private String mResult;
        private String mMsgType;
        private List mMsgInfoList;
        private List mExInfoList;

        public TaskResultInfo() {
            this.mTaskId = JBIManagementMessage.UNKNOWN;
            this.mResult = JBIManagementMessage.UNKNOWN;
            this.mMsgType = JBIManagementMessage.UNKNOWN;
            this.mMsgInfoList = new ArrayList();
            this.mExInfoList = new ArrayList();
        }

        public TaskResultInfo(String taskId, String result, String msgType, List msgInfoList, List exInfoList) {
            this.mTaskId = taskId;
            this.mResult = result;
            this.mMsgType = msgType;
            this.mMsgInfoList = msgInfoList != null ? Collections.unmodifiableList(msgInfoList) : new ArrayList();
            this.mExInfoList = exInfoList != null ? Collections.unmodifiableList(exInfoList) : new ArrayList();
        }

        public String getTaskId() {
            return this.mTaskId;
        }

        public void setTaskId(String taskId) {
            this.mTaskId = taskId;
        }

        public String getResult() {
            return this.mResult;
        }

        public void setResult(String result) {
            this.mResult = result;
        }

        public String getMessageType() {
            return this.mMsgType;
        }

        public void setMessageType(String msgType) {
            this.mMsgType = msgType;
        }

        public List getStatusMessageInfoList() {
            return this.mMsgInfoList;
        }

        public void setStatusMessageInfoList(List msgInfoList) {
            this.mMsgInfoList = msgInfoList;
        }

        public List getExceptionInfoList() {
            return this.mExInfoList;
        }

        public void setExceptionInfoList(List expInfoList) {
            this.mExInfoList = expInfoList;
        }

        public String getStatusMessage() {
            if (this.mMsgInfoList == null || this.mMsgInfoList.size() <= 0) {
                return null;
            }
            StringWriter strWriter = new StringWriter();
            PrintWriter prnWriter = new PrintWriter(strWriter);
            for (MessageInfo msgInfo : this.mMsgInfoList) {
                String msg = msgInfo.getFormattedMessage(false);
                prnWriter.println(msg);
            }
            try {
                prnWriter.close();
                strWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return strWriter.getBuffer().toString();
        }

        public String getExceptionMessage() {
            if (this.mExInfoList == null || this.mExInfoList.size() <= 0) {
                return null;
            }
            StringWriter strWriter = new StringWriter();
            PrintWriter prnWriter = new PrintWriter(strWriter);
            for (ExceptionInfo exInfo : this.mExInfoList) {
                String exMsg = exInfo.getFormattedMessage(true);
                prnWriter.println(exMsg);
            }
            try {
                prnWriter.close();
                strWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return strWriter.getBuffer().toString();
        }

        public String getMessage() {
            String msg = this.getStatusMessage();
            if (msg != null) {
                return msg;
            }
            msg = this.getExceptionMessage();
            return msg;
        }

        public boolean isException() {
            return this.mExInfoList != null && this.mExInfoList.size() > 0;
        }

        public String getStackTrace() {
            if (this.mExInfoList == null || this.mExInfoList.size() <= 0) {
                return null;
            }
            StringWriter strWriter = new StringWriter();
            PrintWriter prnWriter = new PrintWriter(strWriter);
            for (ExceptionInfo exInfo : this.mExInfoList) {
                String stacktrace = exInfo.getStackTrace();
                prnWriter.println(stacktrace);
            }
            try {
                prnWriter.close();
                strWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return strWriter.getBuffer().toString();
        }

        protected String getFormattedMsgWithType(String msgType, String formattedMsg) {
            String l10nType = JBIManagementMessage.getL10NMessageType(msgType);
            return Util.getCommonI18NBundle().getMessage("jbi.result.1st.msg.format", l10nType, formattedMsg);
        }

        protected String getFormatted1stMessage(boolean isCompFormat, String formattedMsg) {
            String i18nKey = "jbi.result.fw.msg";
            if (isCompFormat) {
                i18nKey = "jbi.result.comp.msg";
            }
            return Util.getCommonI18NBundle().getMessage(i18nKey, formattedMsg);
        }

        protected String getFormatted2ndMessage(boolean isCompFormat, String formattedMsg) {
            String i18nKey = "jbi.result.fw.2nd.msg";
            if (isCompFormat) {
                i18nKey = "jbi.result.comp.2nd.msg";
            }
            return Util.getCommonI18NBundle().getMessage(i18nKey, formattedMsg);
        }

        protected String getFormatted1stExpMessage(boolean isCompFormat, String formattedMsg) {
            String i18nKey = "jbi.result.fw.ex.msg";
            if (isCompFormat) {
                i18nKey = "jbi.result.comp.ex.msg";
            }
            return Util.getCommonI18NBundle().getMessage(i18nKey, formattedMsg);
        }

        protected String getFormatted2ndExpMessage(boolean isCompFormat, String formattedMsg) {
            String i18nKey = "jbi.result.fw.2nd.ex.msg";
            if (isCompFormat) {
                i18nKey = "jbi.result.comp.2nd.ex.msg";
            }
            return Util.getCommonI18NBundle().getMessage(i18nKey, formattedMsg);
        }

        protected List getFormattedStatusMessages(List msgInfoList, String msgType, boolean isCompFormat) {
            ArrayList<String> msgList = new ArrayList<String>();
            String formattedMsg = null;
            boolean expFormat = true;
            int msgInfoListSize = msgInfoList.size();
            for (int i = 0; i < msgInfoListSize; ++i) {
                MessageInfo msgInfo = (MessageInfo)msgInfoList.get(i);
                formattedMsg = null;
                if (i == 0) {
                    formattedMsg = this.getFormattedMsgWithType(msgType, msgInfo.getFormattedMessage(!expFormat));
                    formattedMsg = this.getFormatted1stMessage(isCompFormat, formattedMsg);
                } else {
                    formattedMsg = msgInfo.getFormattedMessage(!expFormat);
                    formattedMsg = this.getFormatted2ndMessage(isCompFormat, formattedMsg);
                }
                msgList.add(formattedMsg);
            }
            return msgList;
        }

        protected List getFormattedExceptionMessages(List exList, String msgType, boolean isCompFormat, boolean printExAsMainMsg) {
            ArrayList<String> msgList = new ArrayList<String>();
            String formattedMsg = null;
            boolean expFormat = true;
            boolean exAsMainMsgPrinted = false;
            int expListSize = exList.size();
            for (int i = 0; i < expListSize; ++i) {
                ExceptionInfo exInfo = (ExceptionInfo)exList.get(i);
                formattedMsg = null;
                if (i == 0) {
                    if (printExAsMainMsg) {
                        formattedMsg = this.getFormattedMsgWithType(msgType, exInfo.getFormattedMessage(!expFormat));
                        formattedMsg = this.getFormatted1stMessage(isCompFormat, formattedMsg);
                        exAsMainMsgPrinted = true;
                    } else {
                        formattedMsg = exInfo.getFormattedMessage(expFormat);
                        formattedMsg = this.getFormatted1stExpMessage(isCompFormat, formattedMsg);
                    }
                } else if (exAsMainMsgPrinted && i == 1) {
                    formattedMsg = exInfo.getFormattedMessage(expFormat);
                    formattedMsg = this.getFormatted1stExpMessage(isCompFormat, formattedMsg);
                } else {
                    formattedMsg = exInfo.getFormattedMessage(!expFormat);
                    formattedMsg = this.getFormatted2ndExpMessage(isCompFormat, formattedMsg);
                }
                msgList.add(formattedMsg);
            }
            return msgList;
        }

        public List getAllFormattedMessages(boolean isCompFormat) {
            ArrayList fmtMsgList = new ArrayList();
            String msgType = this.getMessageType();
            List msgInfoList = this.getStatusMessageInfoList();
            List exInfoList = this.getExceptionInfoList();
            boolean printExAsMainMsg = false;
            List fmtStatusMsgList = this.getFormattedStatusMessages(msgInfoList, msgType, isCompFormat);
            if (fmtStatusMsgList.size() == 0) {
                printExAsMainMsg = true;
            }
            List fmtExMsgList = this.getFormattedExceptionMessages(exInfoList, msgType, isCompFormat, printExAsMainMsg);
            fmtMsgList.addAll(fmtStatusMsgList);
            fmtMsgList.addAll(fmtExMsgList);
            return fmtMsgList;
        }

        public List getFormattedStacktraces() {
            String msgType = this.getMessageType();
            ArrayList<String> list = new ArrayList<String>();
            List exList = this.getExceptionInfoList();
            for (ExceptionInfo exInfo : exList) {
                list.add(exInfo.getFormattedStackTrace());
            }
            return list;
        }
    }

    public static class ExceptionInfo {
        private Integer mLevel;
        private MessageInfo mMsgInfo;
        private String mStacktrace;

        public ExceptionInfo(String level, MessageInfo msgInfo, String stackTrace) {
            try {
                this.mLevel = Integer.valueOf(level);
            }
            catch (NumberFormatException ex) {
                this.mLevel = -1;
            }
            this.mMsgInfo = msgInfo;
            this.mStacktrace = stackTrace;
        }

        public Integer getLevel() {
            return this.mLevel;
        }

        public String getStackTrace() {
            return this.mStacktrace;
        }

        public MessageInfo getMessageInfo() {
            return this.mMsgInfo;
        }

        public String getLocalizedMsg() {
            if (this.mMsgInfo != null) {
                return this.mMsgInfo.getLocalizedMsg();
            }
            return null;
        }

        public String getFormattedMessage(boolean isExpFormat) {
            if (this.mMsgInfo != null) {
                return this.mMsgInfo.getFormattedMessage(isExpFormat);
            }
            return null;
        }

        public String getFormattedStackTrace() {
            return this.mStacktrace;
        }
    }

    public static class MessageInfo {
        private String mI18nId;
        private String mLocalizedMsg;
        private List ml10nMsgParams;

        public MessageInfo(String id, String locMsg, List locMsgParams) {
            this.mI18nId = id;
            this.mLocalizedMsg = locMsg == null ? Util.getCommonI18NBundle().getMessage("jbi.remote.exception.msg.root.cause.no.msg") : locMsg;
            this.ml10nMsgParams = locMsgParams != null ? Collections.unmodifiableList(locMsgParams) : new ArrayList();
        }

        public String getI18nId() {
            return this.mI18nId;
        }

        public String getLocalizedMsg() {
            return this.mLocalizedMsg;
        }

        public List getl10nMsgParams() {
            return this.ml10nMsgParams;
        }

        public String getFormattedMessage(boolean isExpFormat) {
            String formattedMsg = null;
            formattedMsg = Util.getCommonI18NBundle().getMessage("jbi.result.msg.format", this.getI18nId(), this.getLocalizedMsg());
            if (isExpFormat) {
                formattedMsg = Util.getCommonI18NBundle().getMessage("jbi.result.ex.msg.format", formattedMsg);
            }
            return formattedMsg;
        }
    }
}

