/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.NMRStatisticsData;
import com.sun.esb.management.common.data.helper.NMRStatisticsDataReader;
import com.sun.esb.management.common.data.helper.NMRStatisticsDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class NMRStatisticsDataWriter
implements NMRStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    static final String FILE_NAME_KEY = "NMRStatisticsData.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, NMRStatisticsData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        NMRStatisticsDataWriter writer = new NMRStatisticsDataWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("NMRStatisticsDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/NMRStatisticsData");
            root.setAttribute("version", "1.0");
            for (String instanceName : dataMap.keySet()) {
                NMRStatisticsData data = dataMap.get(instanceName);
                Element nmrStatisticsDataElementChild = writer.createNMRStatisticsDataElement(document, data);
                root.appendChild(nmrStatisticsDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createNMRStatisticsDataElement(Document document, NMRStatisticsData data) {
        Element nmrStatisticsDataElement = null;
        if (document != null && data != null) {
            Element activeEndpointsListElementChild;
            nmrStatisticsDataElement = document.createElement("NMRStatisticsData");
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(data.getInstanceName());
            }
            nmrStatisticsDataElement.appendChild(instanceNameElementChild);
            Element activeChannelsListElementChild = NMRStatisticsDataWriter.createActiveChannelsList(document, data);
            if (activeChannelsListElementChild != null) {
                nmrStatisticsDataElement.appendChild(activeChannelsListElementChild);
            }
            if ((activeEndpointsListElementChild = NMRStatisticsDataWriter.createActiveEndpointsList(document, data)) != null) {
                nmrStatisticsDataElement.appendChild(activeEndpointsListElementChild);
            }
        }
        return nmrStatisticsDataElement;
    }

    protected static Element createActiveChannelsList(Document document, NMRStatisticsData data) {
        Element activeChannelsListElement = null;
        if (document != null && data != null) {
            activeChannelsListElement = document.createElement("ActiveChannelsList");
            if (data.getActiveChannelsList() != null && data.getActiveChannelsList().size() > 0) {
                for (String channel : data.getActiveChannelsList()) {
                    Element activeChannelElementChild = document.createElement("ActiveChannel");
                    if (activeChannelElementChild != null) {
                        activeChannelElementChild.setTextContent(channel);
                    }
                    activeChannelsListElement.appendChild(activeChannelElementChild);
                }
            }
        }
        return activeChannelsListElement;
    }

    protected static Element createActiveEndpointsList(Document document, NMRStatisticsData data) {
        Element activeEndpointsListElement = null;
        if (document != null && data != null) {
            activeEndpointsListElement = document.createElement("ActiveEndpointsList");
            if (data.getActiveEndpointsList() != null && data.getActiveEndpointsList().size() > 0) {
                for (String endpoint : data.getActiveEndpointsList()) {
                    Element activeEndpointElementChild = document.createElement("ActiveEndpoint");
                    if (activeEndpointElementChild != null) {
                        activeEndpointElementChild.setTextContent(endpoint);
                    }
                    activeEndpointsListElement.appendChild(activeEndpointElementChild);
                }
            }
        }
        return activeEndpointsListElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/nmrstatistics/NMRStatisticsData.xml";
        try {
            Map<String, NMRStatisticsData> map = null;
            map = NMRStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            String content = NMRStatisticsDataWriter.serialize(map);
            System.out.println(content);
            NMRStatisticsDataWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

