/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.NMRStatisticsData;
import com.sun.esb.management.common.data.helper.NMRStatisticsDataReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NMRStatisticsDataCreator {
    static String[] NMR_STATS_ITEM_NAMES = new String[]{"InstanceName", "ListActiveChannels", "ListActiveEndpoints"};
    static String[] NMR_STATS_ITEM_DESCRIPTIONS = new String[]{"Instance Name", "List of active delivery channels", "List of active endpoints"};
    static String[] NMR_STATS_TABLE_INDEX = new String[]{"InstanceName"};
    static String NMR_ACTIVE_CHANNELS = "ActiveChannels";
    static String NMR_ACTIVE_ENDPOINTS = "ActiveEndpoints";

    public static TabularData createTabularData(Map<String, NMRStatisticsData> map) throws ManagementRemoteException {
        TabularDataSupport nmrStatsTable = null;
        try {
            ArrayType activeChannelsArray = new ArrayType(1, SimpleType.STRING);
            ArrayType activeEndpointsArray = new ArrayType(1, SimpleType.STRING);
            OpenType[] nmrStatsItemTypes = new OpenType[]{SimpleType.STRING, activeChannelsArray, activeEndpointsArray};
            CompositeType NMRStatsEntriesType = new CompositeType("NMRStatistics", "NMR Statistics", NMR_STATS_ITEM_NAMES, NMR_STATS_ITEM_DESCRIPTIONS, nmrStatsItemTypes);
            TabularType nmrStatsType = new TabularType("NMRStats", "NMR Statistic Information", NMRStatsEntriesType, NMR_STATS_TABLE_INDEX);
            nmrStatsTable = new TabularDataSupport(nmrStatsType);
            Set<String> instances = map.keySet();
            for (String instanceName : instances) {
                NMRStatisticsData data = map.get(instanceName);
                nmrStatsTable.put(NMRStatisticsDataCreator.getNMRStatistics(NMRStatsEntriesType, data));
            }
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e);
        }
        return nmrStatsTable;
    }

    protected static CompositeData getNMRStatistics(CompositeType NMRStatsEntriesType, NMRStatisticsData data) throws ManagementRemoteException {
        try {
            Object[] values = new Object[]{data.getInstanceName(), data.getActiveChannelsArray(), data.getActiveEndpointsArray()};
            return new CompositeDataSupport(NMRStatsEntriesType, NMR_STATS_ITEM_NAMES, values);
        }
        catch (Exception ex) {
            throw new ManagementRemoteException(ex);
        }
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/nmrstatistics/NMRStatisticsData.xml";
        try {
            Map<String, NMRStatisticsData> map = null;
            map = NMRStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            TabularData data = NMRStatisticsDataCreator.createTabularData(map);
            System.out.println(data);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ManagementRemoteException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

