/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.FrameworkStatisticsDataCreator;
import com.sun.esb.management.common.data.helper.FrameworkStatisticsDataWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class FrameworkStatisticsData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String INSTANCENAME_KEY = "InstanceName";
    public static final String STARTUPTIME_KEY = "StartupTime (ms)";
    public static final String UPTIME_KEY = "UpTime (ms)";
    String instanceName;
    long startupTime;
    long upTime;

    public static TabularData generateTabularData(Map<String, FrameworkStatisticsData> map) {
        TabularData tabularData = null;
        try {
            tabularData = FrameworkStatisticsDataCreator.createTabularData(map);
        }
        catch (ManagementRemoteException managementRemoteException) {
            // empty catch block
        }
        return tabularData;
    }

    public static Map<String, FrameworkStatisticsData> retrieveDataMap(TabularData tabularData) {
        FrameworkStatisticsData data = null;
        HashMap<String, FrameworkStatisticsData> dataMap = null;
        dataMap = new HashMap<String, FrameworkStatisticsData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            data = new FrameworkStatisticsData();
            for (String item : compositeType.keySet()) {
                Object value;
                if (item.equals(INSTANCENAME_KEY)) {
                    value = (String)compositeData.get(item);
                    data.setInstanceName((String)value);
                }
                if (item.equals(STARTUPTIME_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setStartupTime((Long)value);
                }
                if (!item.equals(UPTIME_KEY)) continue;
                value = (Long)compositeData.get(item);
                data.setUpTime((Long)value);
            }
            dataMap.put(data.getInstanceName(), data);
        }
        return dataMap;
    }

    public static String convertDataMapToXML(Map<String, FrameworkStatisticsData> map) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = FrameworkStatisticsDataWriter.serialize(map);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(long uptime) {
        this.upTime = uptime;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n  Instance Name=" + this.getInstanceName());
        buffer.append("\n  Startup Time=" + this.getStartupTime());
        buffer.append("\n  Up Time=" + this.getUpTime());
        buffer.append("\n  ========================================\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

