/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.base.services;

import com.sun.esb.management.base.services.AbstractServiceImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.FileTransferManager;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.Serializable;
import javax.management.MBeanServerConnection;

public abstract class BaseServiceImpl
extends AbstractServiceImpl
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected Object mLastUploadId = null;

    public BaseServiceImpl() {
        super(null, false);
    }

    public BaseServiceImpl(MBeanServerConnection serverConnection) {
        super(serverConnection, false);
    }

    public BaseServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        super(serverConnection, isRemoteConnection);
    }

    protected String uploadFile(String localFilePath) throws ManagementRemoteException {
        File uploadFile = new File(localFilePath);
        if (!uploadFile.exists()) {
            String jbiMgmtMsg = JBIResultXmlBuilder.createJbiResultXml(this.getI18NBundle(), "jbi.ui.client.remote.file.upload.not.exists", new String[]{uploadFile.getAbsolutePath()}, null);
            throw new ManagementRemoteException(new Exception(jbiMgmtMsg));
        }
        String name = uploadFile.getName();
        try {
            FileTransferManager ftpManager = new FileTransferManager(this.getMBeanServerConnection());
            String uploadedFilePath = ftpManager.uploadArchive(uploadFile);
            this.mLastUploadId = ftpManager.getLastUploadId();
            String string = uploadedFilePath;
            return string;
        }
        catch (Exception ex) {
            String jbiMgmtMsg = JBIResultXmlBuilder.createJbiResultXml(this.getI18NBundle(), "jbi.ui.client.remote.file.upload.error", new Object[]{name}, ex);
            throw new ManagementRemoteException(new Exception(jbiMgmtMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUploadedFile() {
        if (this.mLastUploadId == null) {
            return;
        }
        try {
            FileTransferManager ftpManager = new FileTransferManager(this.getMBeanServerConnection());
            ftpManager.removeUploadedArchive(this.mLastUploadId);
            this.mLastUploadId = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.mLastUploadId = null;
        }
    }

    public String downloadFile(String dir, String serverFilePath) throws ManagementRemoteException {
        try {
            FileTransferManager ftpManager = new FileTransferManager(this.getMBeanServerConnection());
            String fileName = new File(serverFilePath).getName();
            ftpManager.downloadArchive(serverFilePath, new File(dir, fileName));
            String string = fileName;
            return string;
        }
        catch (Exception ex) {
            String jbiMgmtMsg = JBIResultXmlBuilder.createJbiResultXml(this.getI18NBundle(), "jbi.ui.client.remote.file.download.error", new Object[]{serverFilePath}, ex);
            throw new ManagementRemoteException(new Exception(jbiMgmtMsg));
        }
    }
}

