/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.ComponentType;
import com.sun.jbi.management.MBeanNames;
import java.io.IOException;
import java.util.Set;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class FacadeMbeanHelper {
    public static final String JBI_DOMAIN = "com.sun.jbi";
    public static final String SERVICE_TYPE_KEY = "ServiceType";
    public static final String TARGET_KEY = "Target";
    public static final String COMPONENT_NAME_KEY = "ComponentName";
    public static final String EQUAL = "=";
    public static final String COLON = ":";
    public static final String COMMA = ",";

    public static Throwable stripJmException(Throwable ex) {
        Throwable currEx = ex;
        while (null != currEx.getCause()) {
            if (!(currEx instanceof JMException) && !(currEx instanceof JMRuntimeException)) {
                return currEx;
            }
            currEx = currEx.getCause();
        }
        return currEx;
    }

    public static ObjectName getComponentLifeCycleFacadeMBeanName(String componentName, ComponentType type, String target, MBeanNames mbeanNames) {
        ObjectName compLCName = null;
        if (ComponentType.BINDING.equals((Object)type)) {
            compLCName = mbeanNames.getBindingMBeanName(componentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, target);
        } else if (ComponentType.ENGINE.equals((Object)type)) {
            compLCName = mbeanNames.getEngineMBeanName(componentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, target);
        }
        return compLCName;
    }

    public static ObjectName[] getComponentLifeCycleObjectNames(MBeanServerConnection mbs, MBeanNames mbns, String target) throws JMException, IOException {
        String objNamePattern = "com.sun.jbi:Target=" + target + COMMA + SERVICE_TYPE_KEY + EQUAL + MBeanNames.ComponentServiceType.ComponentLifeCycle + COMMA + "*";
        ObjectName objName = new ObjectName(objNamePattern);
        Set<ObjectName> nameSet = mbs.queryNames(objName, null);
        return nameSet.toArray(new ObjectName[nameSet.size()]);
    }

    public static ObjectName getComponentLifeCycleObjectName(MBeanServerConnection mbs, MBeanNames mbns, String target, String compName) throws JMException, IOException {
        String objNamePattern = "com.sun.jbi:Target=" + target + COMMA + SERVICE_TYPE_KEY + EQUAL + MBeanNames.ComponentServiceType.ComponentLifeCycle + COMMA + COMPONENT_NAME_KEY + EQUAL + compName;
        ObjectName objName = new ObjectName(objNamePattern);
        Set<ObjectName> nameSet = mbs.queryNames(objName, null);
        return nameSet.iterator().next();
    }
}

