/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import com.sun.jbi.util.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;

public class RuntimeConfiguration
extends com.sun.jbi.management.config.RuntimeConfiguration
implements Constants {
    private static final String DOMAIN = "domain";

    public RuntimeConfiguration(ModelMBeanInfo mbeanInfo, ConfigurationCategory category, String target) throws Exception {
        super(mbeanInfo, category, target);
    }

    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkIsValidAttribute(attribute);
        String string = attribute.getName();
        this.getPlatformContext();
        if (string.equalsIgnoreCase("com.sun.jbi")) {
            try {
                Level logLevel = null;
                if ("DEFAULT".equals(attribute.getValue())) {
                    return;
                }
                if (attribute.getValue() != null) {
                    logLevel = Level.parse(attribute.getValue().toString());
                }
                this.getPlatformContext().setJbiLogLevel(this.mTarget, logLevel);
                return;
            }
            catch (IllegalArgumentException iex) {
                JBIException jbiEx = new JBIException(this.getMgtMessage("setAttribute", iex));
                throw new MBeanException((Exception)((Object)jbiEx));
            }
        }
        try {
            this.notifyListenersOfAttributeChange(attribute);
        }
        catch (Exception ex) {
            JBIException jbiEx = new JBIException(this.getMgtMessage("setAttribute", ex));
            throw new MBeanException((Exception)((Object)jbiEx));
        }
        this.setAttributeOnTarget(attribute);
        this.persistDomainConfig();
        if (!this.mTarget.equals(this.getPlatformContext().getAdminServerName())) {
            try {
                GenericQuery query = this.getRegistry().getGenericQuery();
                Updater updater = this.getRegistry().getUpdater();
                String attrValue = attribute.getValue() == null ? "null" : attribute.getValue().toString();
                String domainValue = query.getAttribute(DOMAIN, this.mCategory, attribute.getName());
                if (domainValue != null && attrValue.equals(domainValue)) {
                    updater.deleteAttribute(this.mTarget, this.mCategory, attribute.getName());
                } else {
                    updater.setAttribute(this.mTarget, this.mCategory, attribute.getName(), attrValue);
                }
            }
            catch (Exception ex) {
                JBIException jbiEx = new JBIException(this.getMgtMessage("setAttribute", ex));
                throw new MBeanException((Exception)((Object)jbiEx));
            }
        }
    }

    public void persist() throws Exception {
        if (DOMAIN.equals(this.mTarget)) {
            super.persist();
        }
    }

    private void setAttributeOnTarget(Attribute attribute) throws MBeanException {
        block8: {
            try {
                if (DOMAIN.equals(this.mTarget)) {
                    List targets = new ArrayList();
                    try {
                        GenericQuery query = this.getRegistry().getGenericQuery();
                        targets = query.getServers();
                        targets.addAll(query.getClusters());
                        for (String target : targets) {
                            this.setGlobalAttributeOnTarget(target, attribute);
                        }
                        break block8;
                    }
                    catch (RegistryException rex) {
                        JBIException jbiEx = new JBIException(sMsgBuilder.buildExceptionMessage("setAttribute", (Throwable)rex));
                        throw new MBeanException((Exception)((Object)jbiEx));
                    }
                }
                if (this.getPlatformContext().isStandaloneServer(this.mTarget)) {
                    this.setAttributeOnInstance(this.mTarget, attribute);
                } else {
                    this.setAttributeOnCluster(attribute);
                }
            }
            catch (ManagementException mex) {
                JBIException jbiEx = new JBIException(mex.getMessage());
                throw new MBeanException((Exception)((Object)jbiEx));
            }
        }
    }

    private void setAttributeOnInstance(String instance, Attribute attribute) throws ManagementException {
        String op = "setAttribute";
        try {
            if (this.getPlatformContext().isInstanceUp(instance)) {
                ObjectName instConfigMBeanName = this.getManagementContext().getMBeanNames(instance).getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType((MBeanNames.ServiceType)MBeanNames.ServiceType.valueOf((String)this.mCategory.toString())));
                MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(instance);
                if (mbns.isRegistered(instConfigMBeanName)) {
                    mbns.setAttribute(instConfigMBeanName, attribute);
                }
            }
        }
        catch (JMException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = sMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (JMRuntimeException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = sMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (Exception ex) {
            throw new ManagementException(sMsgBuilder.buildExceptionMessage(op, (Throwable)ex));
        }
    }

    private void setAttributeOnCluster(Attribute attribute) throws ManagementException {
        HashMap<String, ManagementException> exceptionMap = new HashMap<String, ManagementException>();
        HashMap<String, String> responseMap = new HashMap<String, String>();
        Set instances = this.getPlatformContext().getServersInCluster(this.mTarget);
        for (String instance : instances) {
            try {
                this.setAttributeOnInstance(instance, attribute);
                responseMap.put(instance, sMsgBuilder.buildFrameworkMessage("setAttribute", MessageBuilder.TaskResult.SUCCESS));
            }
            catch (ManagementException mex) {
                exceptionMap.put(instance, mex);
            }
        }
        if (!exceptionMap.isEmpty()) {
            MessageBuilder.Message msg = sMsgBuilder.buildCompositeMessage("setAttribute", responseMap, exceptionMap, false);
            if (msg.isSuccessWithWarning()) {
                String warning = MessageHelper.extractMessageFromXML((String)msg.getMessage(), (Level)RuntimeConfiguration.getLogger().getLevel());
                RuntimeConfiguration.getLogger().fine(warning);
            } else if (msg.isFailure()) {
                throw new ManagementException(msg.getMessage());
            }
        }
    }

    private void setGlobalAttributeOnTarget(String target, Attribute attribute) throws ManagementException {
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (this.getPlatformContext().isStandaloneServer(target)) {
            this.setGlobalAttributeOnInstance(target, attribute, responseMap, exceptionMap);
        } else {
            this.setGlobalAttributeOnCluster(target, attribute, responseMap, exceptionMap);
        }
        if (!exceptionMap.isEmpty()) {
            MessageBuilder.Message msg = sMsgBuilder.buildCompositeMessage("setAttribute", responseMap, exceptionMap, false);
            if (msg.isSuccessWithWarning()) {
                String warning = MessageHelper.extractMessageFromXML((String)msg.getMessage(), (Level)RuntimeConfiguration.getLogger().getLevel());
                RuntimeConfiguration.getLogger().fine(warning);
            } else if (msg.isFailure()) {
                throw new ManagementException(msg.getMessage());
            }
        }
    }

    private void setGlobalAttributeOnInstance(String instance, Attribute attribute, Map<String, String> responseMap, Map<String, Throwable> exceptionMap) {
        String op = "setAttribute";
        try {
            if (this.getPlatformContext().isInstanceUp(instance)) {
                ObjectName instConfigMBeanName = this.getManagementContext().getMBeanNames(DOMAIN).getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType((MBeanNames.ServiceType)MBeanNames.ServiceType.valueOf((String)this.mCategory.toString())));
                MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(instance);
                if (mbns.isRegistered(instConfigMBeanName)) {
                    mbns.setAttribute(instConfigMBeanName, attribute);
                    responseMap.put(instance, sMsgBuilder.buildFrameworkMessage("setAttribute", MessageBuilder.TaskResult.SUCCESS));
                }
            }
        }
        catch (JMException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.getMgtMessage(op, actualEx);
            exceptionMap.put(instance, new ManagementException(errMsg));
        }
        catch (JMRuntimeException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.getMgtMessage(op, actualEx);
            exceptionMap.put(instance, new ManagementException(errMsg));
        }
        catch (Exception ex) {
            exceptionMap.put(instance, new ManagementException(this.getMgtMessage(op, ex)));
        }
    }

    private void setGlobalAttributeOnCluster(String target, Attribute attribute, Map<String, String> responseMap, Map<String, Throwable> exceptionMap) {
        Set instances = this.getPlatformContext().getServersInCluster(target);
        for (String instance : instances) {
            this.setGlobalAttributeOnInstance(instance, attribute, responseMap, exceptionMap);
        }
    }

    private String getMgtMessage(String op, Throwable ex) {
        String msg;
        try {
            msg = sMsgBuilder.buildExceptionMessage(op, ex);
        }
        catch (ManagementException mex) {
            msg = ex.getMessage();
        }
        return msg;
    }
}

