/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.EventNotifierBase;
import com.sun.jbi.management.EventNotifierMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.platform.PlatformContext;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class EventNotifier
extends NotificationBroadcasterSupport
implements EventNotifierBase,
EventNotifierMBean,
NotificationListener {
    private boolean mNotificationsEnabled;
    private Logger mLog = Logger.getLogger("com.sun.jbi.management");
    private MBeanNames mMBeanNames;
    private ObjectName mObjName;
    private PlatformContext mPlatformContext;
    private Hashtable<String, ObjectName> mInstanceList;

    EventNotifier(EnvironmentContext envContext, String target) {
        this.mMBeanNames = envContext.getMBeanNames();
        this.mPlatformContext = envContext.getPlatformContext();
        this.mNotificationsEnabled = true;
        this.mInstanceList = new Hashtable();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifs = new MBeanNotificationInfo[]{new MBeanNotificationInfo(NOTIFICATION_TYPES, "javax.management.Notification", "JBI runtime event")};
        return notifs;
    }

    public boolean disableNotifications() {
        boolean ret = this.mNotificationsEnabled;
        this.mNotificationsEnabled = false;
        this.mLog.fine("Event notifications disabled for domain");
        return ret;
    }

    public boolean enableNotifications() {
        boolean ret = !this.mNotificationsEnabled;
        this.mNotificationsEnabled = true;
        this.mLog.fine("Event notifications enabled for domain");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean instanceStarted(String instanceName, ObjectName objectName) {
        boolean ret = false;
        Hashtable<String, ObjectName> hashtable = this.mInstanceList;
        synchronized (hashtable) {
            boolean added;
            if (!this.mInstanceList.containsKey(instanceName) && (added = this.invokeInstanceMBean("addNotificationListener", instanceName, objectName))) {
                this.mInstanceList.put(instanceName, objectName);
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean instanceStopped(String instanceName, ObjectName objectName) {
        boolean ret = false;
        Hashtable<String, ObjectName> hashtable = this.mInstanceList;
        synchronized (hashtable) {
            if (this.mInstanceList.containsKey(instanceName)) {
                this.invokeInstanceMBean("removeNotificationListener", instanceName, objectName);
                this.mInstanceList.remove(instanceName);
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.mLog.log(Level.FINER, "Received notification from instance {0}: {1}", new Object[]{(String)handback, notification.toString()});
        if (this.mNotificationsEnabled) {
            this.mLog.finer("Forwarding notification");
            this.sendNotification(notification);
        }
    }

    void start() {
        ObjectName mbName;
        Set saServers = this.mPlatformContext.getStandaloneServerNames();
        Set clServers = this.mPlatformContext.getClusteredServerNames();
        for (String server : saServers) {
            if (!this.mPlatformContext.isInstanceUp(server)) continue;
            mbName = this.mMBeanNames.getSystemServiceMBeanName("Framework", "Notification", server);
            this.instanceStarted(server, mbName);
        }
        for (String server : clServers) {
            if (!this.mPlatformContext.isInstanceUp(server)) continue;
            mbName = this.mMBeanNames.getSystemServiceMBeanName("Framework", "Notification", server);
            this.instanceStarted(server, mbName);
        }
    }

    void stop() {
        Set<String> instanceNames = this.mInstanceList.keySet();
        for (String instanceName : instanceNames) {
            ObjectName mbName = this.mInstanceList.get(instanceName);
            if (null == mbName) continue;
            this.instanceStopped(instanceName, mbName);
        }
    }

    private boolean invokeInstanceMBean(String operation, String instanceName, ObjectName objectName) {
        boolean ret = false;
        MBeanServerConnection mbsConn = null;
        try {
            mbsConn = this.mPlatformContext.getMBeanServerConnection(instanceName);
        }
        catch (Throwable ex) {
            this.mLog.log(Level.FINE, "Unable to get MBean server connection  for instance " + instanceName + ", exception follows.", ex);
        }
        if (null != mbsConn) {
            String[] signature = new String[]{"javax.management.NotificationListener", "javax.management.NotificationFilter", "java.lang.Object"};
            Object[] params = new Object[]{this, null, instanceName};
            try {
                this.mLog.log(Level.FINE, "Invoking {0} on MBean {1} on instance {2}", new Object[]{operation, objectName, instanceName});
                mbsConn.invoke(objectName, operation, params, signature);
                ret = true;
            }
            catch (Throwable ex) {
                Throwable actualEx = EventNotifier.stripJmxException(ex);
                this.mLog.log(Level.FINE, "Failure invoking MBean operation, exception follows.", actualEx);
            }
        }
        return ret;
    }

    private static Throwable stripJmxException(Throwable ex) {
        Throwable currEx = ex;
        while (null != currEx.getCause()) {
            if (!(currEx instanceof JMException) && !(currEx instanceof JMRuntimeException)) {
                return currEx;
            }
            currEx = currEx.getCause();
        }
        return currEx;
    }
}

