/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.eventmanagement.impl;

import com.sun.esb.eventmanagement.api.AlertPersistenceDBType;
import com.sun.esb.eventmanagement.api.NotificationEvent;
import com.sun.esb.eventmanagement.impl.AlertLevelType;
import com.sun.esb.eventmanagement.impl.AlertPersistenceConfiguration;
import com.sun.esb.eventmanagement.impl.AlertRemovalPolicyType;
import com.sun.esb.eventmanagement.impl.AlertUtil;
import com.sun.esb.eventmanagement.impl.EventStoreConstants;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.platform.PlatformContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DBEventStore
implements NotificationListener,
EventStoreConstants {
    private static final Logger mLogger = Logger.getLogger(DBEventStore.class.getName());
    private static boolean isDebugEnabled;
    private AlertPersistenceConfiguration mAlertPersistenceConfiguration;
    private String mJndiName;
    private DataSource mDataSource;
    private MBeanServerConnection mMBeanServer;
    Timer mTimer;
    private Boolean mShutdownInProgress;
    private Integer mTimerNotificationId;
    private ObjectName mTimerObjectName;
    private NotificationFilterSupport mTimerFilter;
    private boolean isTimerRunning;
    private static DBEventStore mDBEventStore;
    private PlatformContext mPlatformContext;

    public static synchronized DBEventStore getInstance(AlertPersistenceConfiguration aAlertPersistenceConfiguration, MBeanServerConnection aMBeanServer, PlatformContext aPlatformContext) {
        if (mDBEventStore == null) {
            mDBEventStore = new DBEventStore(aAlertPersistenceConfiguration, aMBeanServer, aPlatformContext);
        }
        return mDBEventStore;
    }

    private DBEventStore(AlertPersistenceConfiguration aAlertPersistenceConfiguration, MBeanServerConnection aMBeanServer, PlatformContext aPlatformContext) {
        this.mMBeanServer = aMBeanServer;
        this.mPlatformContext = aPlatformContext;
        this.mAlertPersistenceConfiguration = aAlertPersistenceConfiguration;
        this.mJndiName = aAlertPersistenceConfiguration.getDataSourceJndiName();
        this.mTimerFilter = new NotificationFilterSupport();
        if (this.mPlatformContext.isAdminServer()) {
            this.registerPolicyExecutionTimer();
        }
        this.mShutdownInProgress = false;
    }

    private void registerPolicyExecutionTimer() {
        try {
            this.mTimer = new Timer();
            this.mTimerObjectName = new ObjectName("EventManagement:type=service,name=RemovalPolicyIntervalTimerService");
            if (this.mPlatformContext.isAdminServer() && ((MBeanServer)this.mMBeanServer).isRegistered(this.mTimerObjectName)) {
                return;
            }
            ((MBeanServer)this.mMBeanServer).registerMBean(this.mTimer, this.mTimerObjectName);
            this.hookUpToTimerService(this.mAlertPersistenceConfiguration.getPersistenceAlertPolicyExecInterval());
            if (this.mAlertPersistenceConfiguration.getPersistedAlertRemovalPolicyExecEnabled().booleanValue()) {
                this.isTimerRunning = true;
                this.mTimer.start();
            }
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.persistence.removal.policy.setup.error.log.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterTimerService() {
        if (!this.mPlatformContext.isAdminServer()) {
            return;
        }
        if (!((MBeanServer)this.mMBeanServer).isRegistered(this.mTimerObjectName)) {
            return;
        }
        this.mTimer.stop();
        this.unHookFromTimerService();
        Boolean bl = this.mShutdownInProgress;
        synchronized (bl) {
            this.mShutdownInProgress = true;
        }
        try {
            ObjectName name = new ObjectName("EventManagement:type=service,name=RemovalPolicyIntervalTimerService");
            if (this.mMBeanServer.isRegistered(name)) {
                this.mMBeanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.persistence.removal.policy.shutdown.error.log.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e);
        }
    }

    public void setDataSourceJndiName(String aJndiName) {
        this.mJndiName = aJndiName;
    }

    public void deleteEvent(String aEventId) throws ManagementRemoteException {
        String deleteEventQuery = "DELETE FROM NOTIFICATION_EVENT  where id = ? ";
        String fixedQuery = this.fixQueryTableName(deleteEventQuery);
        this.deleteEvent(fixedQuery, aEventId);
    }

    public int getPersistedEventCount() {
        int count = 0;
        try {
            count = this.executeCountQuery();
        }
        catch (ManagementRemoteException e) {
            return 0;
        }
        return count;
    }

    public void enablePolicyExecution(boolean aEnable) {
        if (!this.isTimerRunning && aEnable) {
            this.isTimerRunning = true;
            this.mTimer.start();
        }
        if (this.isTimerRunning && !aEnable) {
            this.isTimerRunning = false;
            this.mTimer.stop();
        }
    }

    public void UpdatePolicyExecutionInterval(Long aNewInterval) {
        if (this.isTimerRunning) {
            this.mTimer.stop();
            this.unHookFromTimerService();
            this.hookUpToTimerService(aNewInterval);
            this.mTimer.start();
        } else {
            this.unHookFromTimerService();
            this.hookUpToTimerService(aNewInterval);
        }
    }

    public void initializeDataSource() throws ManagementRemoteException {
        if (this.mDataSource != null) {
            return;
        }
        try {
            InitialContext ic = new InitialContext();
            this.mDataSource = (DataSource)ic.lookup(this.mJndiName);
        }
        catch (NamingException e) {
            Exception exception = AlertUtil.createManagementException("caps.management.server.alert.configuration.initialContext.error", null, e);
            throw new ManagementRemoteException((Throwable)exception);
        }
        if (this.mDataSource == null) {
            Object[] args = new String[]{this.mJndiName};
            Exception e = AlertUtil.createManagementException("caps.management.server.alert.configuration.invalidDataSource.error", args, null);
            throw new ManagementRemoteException((Throwable)e);
        }
    }

    public void reInitializeDataSource(String aNewJndi) {
        try {
            InitialContext ic = new InitialContext();
            this.mDataSource = (DataSource)ic.lookup(aNewJndi);
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.reconfiguration.initialContext.error";
            String message = AlertUtil.constructMessage(bundleKey) + aNewJndi;
            mLogger.log(Level.WARNING, message, e);
        }
    }

    private void deleteEvent(String aSql, String aParamValue) throws ManagementRemoteException {
        Connection lConnection = null;
        Statement ps = null;
        try {
            lConnection = this.mDataSource.getConnection();
            if (lConnection == null) {
                return;
            }
            ps = lConnection.prepareStatement(aSql);
            ps.setString(1, aParamValue);
            ps.execute();
            lConnection.commit();
        }
        catch (SQLException sqle) {
            Object[] args = new String[]{aSql};
            Exception e = AlertUtil.createManagementException("caps.management.client.alert.runtime.delete.error", args, sqle);
            throw new ManagementRemoteException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (lConnection != null) {
                    lConnection.close();
                }
            }
            catch (Exception e) {
                ps = null;
                lConnection = null;
            }
        }
    }

    private int executeCountQuery() throws ManagementRemoteException {
        String lCountQuery = "SELECT count(id) FROM NOTIFICATION_EVENT  ";
        String fixedQuery = this.fixQueryTableName(lCountQuery);
        if (this.mDataSource == null) {
            Object[] args = new String[]{this.mJndiName};
            Exception e = AlertUtil.createManagementException("caps.management.server.alert.configuration.invalidDataSource.error", args, null);
            throw new ManagementRemoteException((Throwable)e);
        }
        Connection lConnection = null;
        Statement stmt = null;
        try {
            lConnection = this.mDataSource.getConnection();
            if (lConnection == null) {
                int n = 0;
                return n;
            }
            stmt = lConnection.createStatement();
            ResultSet rset = stmt.executeQuery(fixedQuery);
            if (rset.next()) {
                int e = rset.getInt(1);
                return e;
            }
        }
        catch (SQLException sqle) {
            Object[] args = new String[]{fixedQuery};
            Exception e = AlertUtil.createManagementException("caps.management.client.alert.runtime.getcount.error", args, sqle);
            throw new ManagementRemoteException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (lConnection != null) {
                    lConnection.close();
                }
            }
            catch (Exception e) {
                stmt = null;
                lConnection = null;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(NotificationEvent notificationEvent) throws ManagementRemoteException {
        if (this.mShutdownInProgress.booleanValue()) {
            String bundleKey = "caps.management.server.alert.persistence.discard.event.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.INFO, message);
            return;
        }
        String fixedQuery = null;
        Connection conn = null;
        Statement pStmt = null;
        Statement stmt = null;
        try {
            conn = this.mDataSource.getConnection();
            if (conn == null) {
                Exception e = AlertUtil.createManagementException("caps.management.server.alert.runtime.database.connection.error", null, null);
                throw new ManagementRemoteException((Throwable)e);
            }
            String query = "insert into NOTIFICATION_EVENT ( timeStamp, physicalHostName, environmentName, logicalHostName, serverType, serverName, componentType, componentProjectPathName, componentName, eventType, severity, operationalState, messageCode, messageDetail, observationalState, deploymentName)  values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            if (this.mAlertPersistenceConfiguration.getAlertPersistenceDBType() == AlertPersistenceDBType.ORACLE) {
                query = "insert into NOTIFICATION_EVENT (id, timeStamp, physicalHostName, environmentName, logicalHostName, serverType, serverName, componentType, componentProjectPathName, componentName, eventType, severity, operationalState, messageCode, messageDetail, observationalState, deploymentName)  values ( autoincrement_id.nextval, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            }
            fixedQuery = this.fixQueryTableName(query);
            pStmt = conn.prepareStatement(fixedQuery);
            pStmt.setLong(1, notificationEvent.getTimeStamp());
            String phyHostName = notificationEvent.getPhysicalHostName() == null ? " " : notificationEvent.getPhysicalHostName();
            pStmt.setString(2, phyHostName);
            String envName = notificationEvent.getEnvironmentName() == null ? " " : notificationEvent.getEnvironmentName();
            pStmt.setString(3, envName);
            String lglHostName = notificationEvent.getLogicalHostName() == null ? " " : notificationEvent.getLogicalHostName();
            pStmt.setString(4, lglHostName);
            String serverType = notificationEvent.getServerType() == null ? " " : notificationEvent.getServerType();
            pStmt.setString(5, serverType);
            String serverName = notificationEvent.getServerName() == null ? " " : notificationEvent.getServerName();
            pStmt.setString(6, serverName);
            String componentType = notificationEvent.getComponentType() == null ? " " : notificationEvent.getComponentType();
            pStmt.setString(7, componentType);
            String compProjPathName = notificationEvent.getComponentProjectPathName() == null ? " " : notificationEvent.getComponentProjectPathName();
            pStmt.setString(8, compProjPathName);
            String componentName = notificationEvent.getComponentName() == null ? " " : notificationEvent.getComponentName();
            pStmt.setString(9, componentName);
            String type = notificationEvent.getType() == null ? " " : notificationEvent.getType();
            pStmt.setString(10, type);
            pStmt.setInt(11, notificationEvent.getSeverity());
            pStmt.setInt(12, notificationEvent.getOperationalState());
            String msgCode = notificationEvent.getMessageCode() == null ? " " : notificationEvent.getMessageCode();
            pStmt.setString(13, msgCode);
            String msgDetails = notificationEvent.getMessageDetails() == null ? " " : notificationEvent.getMessageDetails();
            pStmt.setString(14, msgDetails);
            pStmt.setInt(15, notificationEvent.getObservationalState());
            String depName = notificationEvent.getDeploymentName() == null ? " " : notificationEvent.getDeploymentName();
            pStmt.setString(16, depName);
            pStmt.executeUpdate();
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Executed:{0}", fixedQuery);
            }
        }
        catch (Exception e) {
            try {
                String resourceKey = null;
                String[] args = null;
                if (fixedQuery == null) {
                    resourceKey = "caps.management.server.alert.runtime.connectionnotavaiableforinsert.error";
                } else {
                    args = new String[]{fixedQuery};
                    resourceKey = "caps.management.server.alert.runtime.insertalert.error";
                }
                Exception exception = AlertUtil.createManagementException(resourceKey, args, e);
                throw new ManagementRemoteException((Throwable)exception);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    Object[] args = new String[]{fixedQuery};
                    Exception exception = AlertUtil.createManagementException("caps.management.server.alert.runtime.failtoclosestatementorconnection.error", args, e2);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (pStmt != null) {
                pStmt.close();
            }
            if (conn == null) return;
            conn.close();
            return;
        }
        catch (Exception e) {
            Object[] args = new String[]{fixedQuery};
            Exception exception = AlertUtil.createManagementException("caps.management.server.alert.runtime.failtoclosestatementorconnection.error", args, e);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!notification.getType().equals("alertsDB.removalPolicy")) {
            return;
        }
        List<AlertRemovalPolicyType> list = this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList();
        synchronized (list) {
            if (!this.mAlertPersistenceConfiguration.getPersistedAlertRemovalPolicyExecEnabled().booleanValue()) {
                return;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<AlertRemovalPolicyType> safeList = null;
                    List<AlertRemovalPolicyType> list = DBEventStore.this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList();
                    synchronized (list) {
                        if (DBEventStore.this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList() == null || DBEventStore.this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList().size() <= 0) {
                            return;
                        }
                        safeList = Collections.unmodifiableList(DBEventStore.this.mAlertPersistenceConfiguration.getAlertRemovalPolicyTypeList());
                    }
                    DBEventStore.this.ExecutePolicy(safeList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExecutePolicy(List<AlertRemovalPolicyType> aPolicyList) throws ManagementRemoteException {
        Boolean bl = this.mShutdownInProgress;
        synchronized (bl) {
            if (this.mShutdownInProgress.booleanValue()) {
                return;
            }
        }
        for (AlertRemovalPolicyType alertRemovalPolicyType : aPolicyList) {
            Boolean bl2 = this.mShutdownInProgress;
            synchronized (bl2) {
                if (this.mShutdownInProgress.booleanValue()) {
                    return;
                }
            }
            if (this.getPersistedEventCount() == 0) {
                return;
            }
            String deleteSql = null;
            switch (alertRemovalPolicyType) {
                case ALERTS_LEVEL: {
                    AlertLevelType alertLevel = this.mAlertPersistenceConfiguration.getPersistenceAlertLevelPolicyValue();
                    if (AlertLevelType.NONE == alertLevel) break;
                    String alertLevelInt = alertLevel.getAlertLevelAsIntString();
                    deleteSql = "DELETE FROM NOTIFICATION_EVENT  where severity >= ?  ";
                    String fixedQuery = this.fixQueryTableName(deleteSql);
                    this.deleteEvent(fixedQuery, alertLevelInt);
                    break;
                }
                case ALERTS_COUNT: {
                    long alertMaxCount = this.mAlertPersistenceConfiguration.getPersistenceAlertCountPolicyValue();
                    if (alertMaxCount > (long)this.getPersistedEventCount()) break;
                    this.removeExcessiveAlerts((int)alertMaxCount);
                    break;
                }
                case ALERTS_AGE: {
                    long alertAge = this.mAlertPersistenceConfiguration.getPersistenceAlertAgePolicyValue();
                    Long lastValidEventDate = new Date().getTime() - alertAge;
                    deleteSql = "DELETE FROM NOTIFICATION_EVENT  where TIMESTAMP < ? ";
                    String fixedQuery = this.fixQueryTableName(deleteSql);
                    this.deleteEvent(fixedQuery, lastValidEventDate.toString());
                }
            }
        }
    }

    private void removeExcessiveAlerts(int aMaxRowCount) throws ManagementRemoteException {
        if (this.mDataSource == null) {
            return;
        }
        String fixedQuery = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.mDataSource.getConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.createStatement(1004, 1007);
            String query = "SELECT TIMESTAMP FROM NOTIFICATION_EVENT   order by TIMESTAMP desc";
            fixedQuery = this.fixQueryTableName(query);
            ResultSet rset = stmt.executeQuery(fixedQuery);
            rset.relative(aMaxRowCount);
            String currentRowDate = rset.getString(1);
            String deleteSql = "DELETE FROM NOTIFICATION_EVENT  where TIMESTAMP < ? ";
            fixedQuery = this.fixQueryTableName(deleteSql);
            this.deleteEvent(fixedQuery, currentRowDate);
        }
        catch (Exception e) {
            Object[] args = new String[]{fixedQuery};
            Exception lException = AlertUtil.createManagementException("caps.management.client.alert.runtime.delete.error", args, e);
            throw new ManagementRemoteException((Throwable)lException);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                stmt = null;
                conn = null;
            }
        }
    }

    private void hookUpToTimerService(Long aTimeIntervalForArchive) {
        try {
            this.mTimerFilter.enableType("alertsDB.removalPolicy");
            this.mMBeanServer.addNotificationListener(this.mTimerObjectName, this, (NotificationFilter)this.mTimerFilter, null);
            Object[] paramsArray = new Object[]{"alertsDB.removalPolicy", "alerts removal interval", null, new Date(), aTimeIntervalForArchive};
            String[] paramsSig = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"};
            this.mTimerNotificationId = (Integer)this.mMBeanServer.invoke(this.mTimerObjectName, "addNotification", paramsArray, paramsSig);
        }
        catch (Exception ex) {
            String bundleKey = "caps.management.server.alert.runtime.timer.hook.error.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, ex);
        }
    }

    private void unHookFromTimerService() {
        try {
            if (this.mMBeanServer.isRegistered(this.mTimerObjectName)) {
                this.mMBeanServer.removeNotificationListener(this.mTimerObjectName, this);
                if (this.mTimerNotificationId != null) {
                    Object[] paramsArray = new Object[]{this.mTimerNotificationId};
                    String[] paramsSig = new String[]{"java.lang.Integer"};
                    this.mMBeanServer.invoke(this.mTimerObjectName, "removeNotification", paramsArray, paramsSig);
                }
            }
        }
        catch (Exception e) {
            String bundleKey = "caps.management.server.alert.runtime.timer.unhook.error.msg";
            String message = AlertUtil.constructLogMessage(bundleKey);
            mLogger.log(Level.WARNING, message, e.getMessage());
        }
    }

    private String replaceQueryTokens(String src, String[] tokensReplacements) {
        String result = src;
        for (int index = 0; index < tokensReplacements.length; ++index) {
            String constructToken = "?" + index;
            result = result.replaceAll(constructToken, tokensReplacements[index]);
        }
        return result;
    }

    private String fixQueryTableName(String originalQuery) {
        String fixedQuery = originalQuery.replace("NOTIFICATION_EVENT", this.mAlertPersistenceConfiguration.getAlertTableName());
        return fixedQuery;
    }
}

