/*
 * BEGIN_HEADER - DO NOT EDIT
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * If applicable add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */

/*
 * @(#)EventImpl.java
 * Copyright 2004-2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 * END_HEADER - DO NOT EDIT
 */


package com.sun.esb.eventmanagement.impl;

import java.io.Serializable;
import java.util.Date;

import com.sun.esb.eventmanagement.api.Event;

/**
 * A class representing an event.
 *
 * @author bgebbie
 *
 */

public class EventImpl 
    implements Event, Serializable {

    static final long serialVersionUID = 4776287904788173388L;

    /**
     * The notification event id (autogenerated).
     */
    protected long mId;

    /**
     * The physical host name.
     */
    protected String mPhysicalHostName;

	/**
	 * The deployment name.
	 */
	protected String mDeploymentName;
    
    /**
     * The environment name.
     */
    protected String mEnvironmentName;

    /**
     * The logical host name.
     */
    protected String mLogicalHostName;

    /**
     * The server type.
     */
    protected String mServerType;

    /**
     * The server name.
     */
    protected String mServerName;

    /**
     * The component type.
     */
    protected String mComponentType;

    /**
     * The project the component is in.
     */
    protected String mComponentProjectPathName;

    /**
     * The component name.
     */
    protected String mComponentName;

    /**
     * The time that the event was generated.
     */
    protected long mTimeStamp;

    /**
     * Event Constructor.
     * empty constructor
     */
    public EventImpl() {
    }

	/**
	 * Event Constructor.
	 *
	 * @param physicalHostName         the name of the physical host
	 * @param deploymentName           the name of the deployment
	 * @param environmentName          the name of the environment
	 * @param logicalHostName          the name of the logical host
	 * @param serverType               the type of the server (INTEGRATION,
	 *                                 MESSAGE)
	 * @param serverName               the name of the server
	 * @param componentType            the type of the component
	 *                                 (COLLABORATION_COMPONENT)
	 * @param componentProjectPathName the full path name of the project in
	 *                                 which the component is in. Note the names
	 *                                 of the project and its sub-projects, if
	 *                                 any, are separated by '/'.
	 * @param componentName            the name of the component
	 * @param timeStamp                the timestamp of when the event was
	 *                                 generated
	 */
	public EventImpl(String physicalHostName,
				 String deploymentName,
				 String environmentName,
				 String logicalHostName,
				 String serverType,
				 String serverName,
				 String componentType,
				 String componentProjectPathName,
				 String componentName,
				 long timeStamp) {

		mPhysicalHostName = physicalHostName;
		mDeploymentName = deploymentName;
		mEnvironmentName = environmentName;
		mLogicalHostName = logicalHostName;
		mServerType = serverType;
		mServerName = serverName;
		mComponentType = componentType;
		mComponentProjectPathName = componentProjectPathName;
		mComponentName = componentName;
		mTimeStamp = timeStamp;
	}

    /**
     * Event Constructor.
     *
     * @param physicalHostName         the name of the physical host
     * @param environmentName          the name of the environment
     * @param logicalHostName          the name of the logical host
     * @param serverType               the type of the server (INTEGRATION,
     *                                 MESSAGE)
     * @param serverName               the name of the server
     * @param componentType            the type of the component
     *                                 (COLLABORATION_COMPONENT)
     * @param componentProjectPathName the full path name of the project in
     *                                 which the component is in. Note the names
     *                                 of the project and its sub-projects, if
     *                                 any, are separated by '/'.
     * @param componentName            the name of the component
     * @param timeStamp                the timestamp of when the event was
     *                                 generated
     */
    public EventImpl(String physicalHostName,
                 String environmentName,
                 String logicalHostName,
                 String serverType,
                 String serverName,
                 String componentType,
                 String componentProjectPathName,
                 String componentName,
                 long timeStamp) {

        mPhysicalHostName = physicalHostName;
        mEnvironmentName = environmentName;
        mLogicalHostName = logicalHostName;
        mServerType = serverType;
        mServerName = serverName;
        mComponentType = componentType;
        mComponentProjectPathName = componentProjectPathName;
        mComponentName = componentName;
        mTimeStamp = timeStamp;
    }


    /**
     * Event Constructor.
     *
     * @param componentType            the type of the component
     *                                 (COLLABORATION_COMPONENT)
     * @param componentProjectPathName the full path name of the project in
     *                                 which the component is in. Note the names
     *                                 of the project and its sub-projects, if
     *                                 any, are separated by '/'.
     * @param componentName            the name of the component
     * @param timeStamp                the timestamp of when the event was
     *                                 generated
     */
    public EventImpl(String componentType,
                 String componentProjectPathName,
                 String componentName,
                 long timeStamp) {

        mComponentType = componentType;
        mComponentProjectPathName = componentProjectPathName;
        mComponentName = componentName;
        mTimeStamp = timeStamp;
    }


    /**
     * The getter method for the physical host name.
     *
     * @return the physical host name
     * @hibernate.property
     */
    public String getPhysicalHostName() {

        return mPhysicalHostName;
    }

    /**
     * The setter method for the physical host name.
     *
     * @param physicalHostName the name of the physical host
     */
    public void setPhysicalHostName(String physicalHostName) {

        mPhysicalHostName = physicalHostName;
    }

	/**
	 * The getter method for the deployment name.
	 *
	 * @return the deployment name
	 *
	 * @hibernate.property
	 */
	public String getDeploymentName() {
		
		return mDeploymentName;
	}

	/**
	 * The setter method for the deployment name.
	 *
	 * @param deploymentName the name of the deployment
	 */
	public void setDeploymentName(String deploymentName) {
		
		mDeploymentName = deploymentName;
	}
    
    /**
     * The getter method for the environment name.
     *
     * @return the environment name
     *
     * @hibernate.property
     */
    public String getEnvironmentName() {

        return mEnvironmentName;
    }

    /**
     * The setter method for the environment name.
     *
     * @param environmentName the name of the environment
     */
    public void setEnvironmentName(String environmentName) {

        mEnvironmentName = environmentName;
    }

    /**
     * The getter method for the logical host name.
     *
     * @return the logical host name
     *
     * @hibernate.property
     */
    public String getLogicalHostName() {

        return mLogicalHostName;
    }

    /**
     * The setter method for the logical host name.
     *
     * @param logicalHostName the name of the logical host
     */
    public void setLogicalHostName(String logicalHostName) {

        mLogicalHostName = logicalHostName;
    }

    /**
     * The getter method for the server type.
     *
     * @return the server type
     *
     * @hibernate.property
     */
    public String getServerType() {

        return mServerType;
    }

    /**
     * The setter method for the server type.
     *
     * @param serverType the type of the server
     */
    public void setServerType(String serverType) {

        mServerType = serverType;
    }

    /**
     * The getter method for the server name.
     *
     * @return the server name
     *
     * @hibernate.property
     */
    public String getServerName() {

        return mServerName;
    }

    /**
     * The setter method for the server name.
     *
     * @param serverName the name of the server
     */
    public void setServerName(String serverName) {

        mServerName = serverName;
    }

    /**
     * The getter method for the component type.
     *
     * @return the component type
     *
     * @hibernate.property
     */
    public String getComponentType() {

        return mComponentType;
    }

    /**
     * The setter method for the component type.
     *
     * @param componentType the type of the component
     */
    public void setComponentType(String componentType) {

        mComponentType = componentType;
    }

    /**
     * The getter method for the component's project.
     *
     * @return the full path name of the project in which the component is in
     *
     * @hibernate.property
     */
    public String getComponentProjectPathName() {

        return mComponentProjectPathName;
    }

    /**
     * The setter method for the full path name of the project in which
     * the component is in.
     * Note the names of the project and its sub-projects, if any, are separated
     * by '/'.
     *
     * @param componentProjectPathName the project
     */
    public void setComponentProjectPathName(String componentProjectPathName) {

        mComponentProjectPathName = componentProjectPathName;
    }

    /**
     * The getter method for the component name.
     *
     * @return the component name
     *
     * @hibernate.property
     */
    public String getComponentName() {

        return mComponentName;
    }

    /**
     * The setter method for the component name.
     *
     * @param componentName the name of the component
     */
    public void setComponentName(String componentName) {

        mComponentName = componentName;
    }

    /**
     * The getter method for the time stamp.
     *
     * @return the time stamp
     *
     * @hibernate.property
     */
    public long getTimeStamp() {

        return mTimeStamp;
    }

    /**
     * The setter method for the time stamp.
     */
    public void setTimeStamp() {

        mTimeStamp = new Date().getTime();
    }

    /**
     * The setter method for the time stamp.
     *
     * @param timeStamp the time stamp
     */
    public void setTimeStamp(long timeStamp) {

        mTimeStamp = timeStamp;
    }

    /**
     * Compare two Event objects.

     /**
     * Compare two Event objects.
     *
     * @param o the other event to compare to
     *
     * @return <code>true</code> if they are equivalent and <code>false</code>
     * if they are not
     */
    public boolean equals(Object o) {

        if (this == o)
            return true;

        if (!(o instanceof Event))
            return false;

        final Event event = (Event) o;

        //
        // Put cheapest comparisons first followed by ones must likely to be
        // false.
        //

        if (mTimeStamp != event.getTimeStamp())
            return false;

        if (mComponentName != null
            ? !mComponentName.equals(event.getComponentName())
            : event.getComponentName() != null)
            return false;

        if (mServerName != null
            ? !mServerName.equals(event.getServerName())
            : event.getServerName() != null)
            return false;

        if (mLogicalHostName != null
            ? !mLogicalHostName.equals(event.getLogicalHostName())
            : event.getLogicalHostName() != null)
            return false;

        if (mEnvironmentName != null
            ? !mEnvironmentName.equals(event.getEnvironmentName())
            : event.getEnvironmentName() != null)
            return false;

        if (mPhysicalHostName != null
            ? !mPhysicalHostName.equals(event.getPhysicalHostName())
            : event.getPhysicalHostName() != null)
            return false;

        if (mServerType != null
            ? !mServerType.equals(event.getServerType())
            : event.getServerType() != null)
            return false;


        if (mComponentType != null
            ? !mComponentType.equals(event.getComponentType())
            : event.getComponentType() != null)
            return false;

        if (mComponentProjectPathName != null
            ? !mComponentProjectPathName.equals(event.getComponentProjectPathName())
            : event.getComponentProjectPathName() != null)
            return false;

        return true;
    }

    /**
     * Generate a hashcode for the event.
     *
     * @return the hashcode for the event
     */
    public int hashCode() {

        int result = 0;

        result = 29 * result + (mPhysicalHostName != null
            ? mPhysicalHostName.hashCode()
            : 0);

        result = 29 * result + (mLogicalHostName != null
            ? mLogicalHostName.hashCode()
            : 0);

        result = 29 * result + (mEnvironmentName != null
            ? mEnvironmentName.hashCode()
            : 0);

        result = 29 * result + (mServerType != null
            ? mServerType.hashCode()
            : 0);

        result = 29 * result + (mServerName != null
            ? mServerName.hashCode()
            : 0);

        result = 29 * result + (mComponentType != null
            ? mComponentType.hashCode()
            : 0);

        result = 29 * result + (mComponentProjectPathName != null
            ? mComponentProjectPathName.hashCode()
            : 0);

        result = 29 * result + (mComponentName != null
            ? mComponentName.hashCode()
            : 0);

        result = 29 * result + (int) (mTimeStamp ^ (mTimeStamp >>> 32));

        return result;
    }

    /**
     * Generate a string representation of the event.
     *
     * @return the string representation of the event
     */
    public String toString() {

        StringBuffer s = new StringBuffer();

        s.append("\tPhysical host name:        ");
        if ( mPhysicalHostName!=null ) {
            s.append(mPhysicalHostName);
        }

        s.append("\n");
        s.append("\tEnvironment name:          ");
        if ( mEnvironmentName!=null ) {
            s.append(mEnvironmentName);
        }

        s.append("\n");
        s.append("\tLogical host name:         ");
        if ( mLogicalHostName!=null ) {
            s.append(mLogicalHostName);
        }

        s.append("\n");
        s.append("\tServer type:               ");
        if ( mServerType!=null ) {
            s.append(mServerType);
        }

        s.append("\n");
        s.append("\tServer name:               ");
        if ( mServerName!=null ) {
            s.append(mServerName);
        }

        s.append("\n");
        s.append("\tComponent type:            ");
        if ( mComponentType!=null ) {
            s.append(mComponentType);
        }

        s.append("\n");
        s.append("\tComponent name:            ");
        if ( mComponentName!=null ) {
            s.append(mComponentName);
        }

        s.append("\n");
        s.append("\tProject path of component: ");   
        if ( mComponentProjectPathName!=null ) {     
            s.append(mComponentProjectPathName);
        }

        s.append("\n");
        s.append("\tTime this event occurred:  ");
        s.append(new Date(mTimeStamp).toString());

        return s.toString();
    }

    /**
     * The notification event id
     *
     * @return the notification event id
     *
     * @hibernate.id generator-class="hilo.long"
     */
    public long getId() {
        return mId;
    }

    /**
     * Set the id.  This should never be called explicitly as persistance
     * mechanism will override this value.
     *
     * @param id the id
     */
    public void setId(long id) {
        mId = id;
    }
}
