/*
 * BEGIN_HEADER - DO NOT EDIT
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * If applicable add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */

/*
 * @(#)MessageCodes.java
 * Copyright 2004-2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 * END_HEADER - DO NOT EDIT
 */
package com.sun.esb.eventmanagement.api;

/**
  * An interface to track message codes.
  *
  * @author bgebbie
  */
public abstract class MessageCodes {


    //
    // Message Codes
    //
    // Format:
    //      'MC_' + generated by [LH - logical host, CO - collaboration, etc.,]
    //              + '_' + mnemonic + '_' + number of arguments
    // Note number of arguments help visually verify that argument list will
    // match expectations.
    //
    // The string value should be two letter abbrevation of what generated the
    // message followed by 5 digit number which should not be reused so exact
    // spot that generated alert can easily be identified. This can be used
    // by customer support to build knowledge base of common errors encountered.
    //
    // The constants should always be used so that the codes can be renamed
    // as desired.
    //
    // Each constant should have a javadoc comment with:
    //
    // A detailed comment about the message code would be appreciated.
    //
    // A sample of the error message to be displayed shold be enclosed in
    // <code>....</code> tags where {<arg #>} is used to display where the
    // arguments should be placed.  The acutal message will reside in property
    // bundles that have been translated to the appropriate language and are
    // keyed by the given string.
    //
    // The email and extension of a contact should be added to an author tag
    // so that it is easy to track down a person when there are problems.

    /**
     * Logical Host Exited
     * <code>Logical Host {2} in {1} on {0} exited.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_EXITED_3 = "LH-00001";

    /**
     * Logical Host Running
     * <code>Logical Host {2} in {1} on {0} is running.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_RUNNING_3 = "LH-00002";

    /**
     * Logical Host Started
     * <code>Logical Host {2} in {1} on {0} started.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_STARTED_3 = "LH-00003";

    /**
     * Logical Host Stopped
     * <code>Logical Host {2} in {1} on {0} stopped.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_STOPPED_3 = "LH-00004";

    /**
     * Logical Host Stopped
     * <code>Logical Host {2} in {1} on {0} stopped.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_STOPPED2_3 = "LH-00005";

    /**
     * Logical Host Killed
     * <code>Logical Host {2} in {1} on {0} killed.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_KILLED_3 = "LH-00006";

    /**
     * Logical Host Not Responding
     * <code>Logical Host {2} in {1} on {0} is now running.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_NOT_RESPONDING_3 = "LH-00007";

    /**
     * Logical Host Already Running
     * <code>Logical Host {2} in {1} on {0} is already running.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     * @author
     */
    public static final String MC_LH_ALREADY_RUNNING_3 = "LH-00008";

    /**
     * Integration Server Started
     * <code>Integration Server {0} started.</code>
     * Params:
     *      {0} integration server name
     * @author
     */
    public static final String MC_IS_STARTED_1 = "IS-00001";

    /**
     * Integration Server Stopped
     * <code>Integration Server {0} has stopped.</code>
     * Params:
     *      {0} integration server name
     * @author
     */
    public static final String MC_IS_STOPPED_1 = "IS-00002";
    public static final String MC_IS_STARTING_1 = "IS-00003";
    public static final String MC_IS_STOPPING_1 = "IS-00004";
    public static final String MC_IS_KILLED_1 = "IS-00005";


    // Message Server Codes
    public static final String MC_MS_EXITED_4 = "MS-00001";
    public static final String MC_MS_RUNNING_4 = "MS-00002";
    public static final String MC_MS_STARTED_4 = "MS-00003";
    public static final String MC_MS_STOPPED_4 = "MS-00004";
    public static final String MC_MS_STOPPED2_4 = "MS-00005";
    public static final String MC_MS_KILLED_4 = "MS-00006";
    public static final String MC_MS_NOT_RESPONDING_4 = "MS-00007";
    public static final String MC_MS_ALREADY_RUNNING_4 = "MS-00008";
    public static final String MC_MS_MESSAGE_LIMIT_EXCEEDED = "MS-00100";
        
    /**
     * Collaboration is Running
     * <code>Collaboration {5} under Project {4} on {3} on {2} in {1} on {0} is running.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     *      {3} server name
     *      {4} project name
     *      {5} collaboration name
     * @author
     */
    public static final String MC_COLLAB_IS_RUNNING_6 = "COL-00001";

    
    /**
     * Collaboration is Stopped
     * <code>Collaboration {5} under Project {4} on {3} on {2} in {1} on {0} is stopped.</code>
     * Params:
     *      {0} physical host name
     *      {1} environment name
     *      {2} logical host name
     *      {3} server name
     *      {4} project name
     *      {5} collaboration name
     * @author
     */
    public static final String MC_COLLAB_IS_STOPPED_6 = "COL-00002";

    public static final String MC_COLLAB_CUSTOM_USER = "COL-00003";
        
    /**
     * Integration Server Is Not Available
     * <code>SNMP Agent has been configured.</code>
     * Params:
     *          <none>
     * @author
     */
    public static final String MC_SNMP_CONFIGURED_0 = "SNMP-00001";  
    
    /**
     * Integration Server Is Not Available
     * <code>SNMP Agent needs to be configured.</code>
     * Params:
     *          <none>
     * @author
     */
    public static final String MC_SNMP_NOT_CONFIGURED_0 = "SNMP-00002";

    public static final String MC_SNMP_RUNNING = "SNMP-00003";
    public static final String MC_SNMP_STOPPED = "SNMP-00004";
    public static final String MC_SNMP_NOT_INSTALLED = "SNMP-00005";


}
