/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.ImmutableHolidayCalendar;
import net.objectlab.kit.datecalc.common.KitCalculatorsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKitCalculatorsFactory<E>
implements KitCalculatorsFactory<E> {
    private final ConcurrentMap<String, HolidayCalendar<E>> holidays = new ConcurrentHashMap<String, HolidayCalendar<E>>();

    @Override
    public void registerHolidays(String name, HolidayCalendar<E> holidaysCalendar) {
        if (name != null) {
            HashSet<E> hol = new HashSet<E>();
            if (holidaysCalendar != null && holidaysCalendar.getHolidays() != null) {
                hol.addAll(holidaysCalendar.getHolidays());
            }
            DefaultHolidayCalendar<E> defaultHolidayCalendar = new DefaultHolidayCalendar<E>(hol);
            if (holidaysCalendar != null) {
                defaultHolidayCalendar.setEarlyBoundary(holidaysCalendar.getEarlyBoundary());
                defaultHolidayCalendar.setLateBoundary(holidaysCalendar.getLateBoundary());
            }
            this.holidays.put(name, new ImmutableHolidayCalendar<E>(holidaysCalendar));
        }
    }

    @Override
    public boolean isHolidayCalendarRegistered(String name) {
        return name != null && this.holidays.containsKey(name);
    }

    @Override
    public HolidayCalendar<E> getHolidayCalendar(String name) {
        return (HolidayCalendar)this.holidays.get(name);
    }

    protected void setHolidays(String name, DateCalculator<E> dc) {
        if (name != null) {
            dc.setHolidayCalendar((HolidayCalendar)this.holidays.get(name));
        }
    }

    @Override
    public Set<String> getRegisteredHolidayCalendarNames() {
        return Collections.unmodifiableSet(this.holidays.keySet());
    }

    @Override
    public void unregisterHolidayCalendar(String calendarName) {
        this.holidays.remove(calendarName);
    }

    @Override
    public void unregisterAllHolidayCalendars() {
        this.holidays.clear();
    }
}

